/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChangesFileIO {
    private static final String CODE_NAME = "Code name:";
    private static final String PROJECT_NAME_PATTERN = "[\\w\\s-]+";
    private static final String VERSION_PATTERN = "\\d+\\.\\d+\\.\\d+";
    private static final String DATE_PATTERN = "\\d{4}-[\\d?]{2}-[\\d?]{2}";
    private static final Pattern FIRST_LINE_PATTERN = Pattern.compile("^# ([\\w\\s-]+) (\\d+\\.\\d+\\.\\d+), released (\\d{4}-[\\d?]{2}-[\\d?]{2})$");
    private static final String LINE_SEPARATOR = "\n";

    public ChangesFile read(Path file) {
        ChangesFile changesFile;
        BufferedReader fileReader = new BufferedReader(new FileReader(file.toFile()));
        try {
            changesFile = this.read(file, fileReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder("F-PK-CORE-39").message("Failed to read changes file {{file}}.", new Object[0]).parameter("file", file.toString()).toString(), exception);
            }
        }
        fileReader.close();
        return changesFile;
    }

    ChangesFile read(Path file, BufferedReader fileReader) throws IOException {
        return new Parser(file, fileReader).parse();
    }

    public void write(ChangesFile changesFile, Path destinationFile) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile.toFile()));){
            this.write(changesFile, writer);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-41").message("Failed to write changes file {{file name}}.", new Object[0]).parameter("file name", destinationFile).toString(), exception);
        }
    }

    void write(ChangesFile changesFile, Writer writer) throws IOException {
        this.writeHeader(writer, changesFile);
        for (ChangesFileSection section : changesFile.getSections()) {
            this.writeSection(writer, section);
        }
        Optional<ChangesFileSection> dependencyChangeSection = changesFile.getDependencyChangeSection();
        if (dependencyChangeSection.isPresent()) {
            writer.write(dependencyChangeSection.get().toString());
            writer.write(LINE_SEPARATOR);
        }
    }

    private void writeHeader(Writer writer, ChangesFile changesFile) throws IOException {
        writer.write("# " + changesFile.getProjectName() + " " + changesFile.getProjectVersion() + ", released " + changesFile.getReleaseDate());
        writer.write(LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        writer.write(CODE_NAME + (String)(changesFile.getCodeName() != null ? " " + changesFile.getCodeName() : ""));
        writer.write(LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        Optional<ChangesFileSection> summarySection = changesFile.getSummarySection();
        if (summarySection.isPresent()) {
            writer.write(summarySection.get().toString());
            writer.write(LINE_SEPARATOR);
        }
    }

    private void writeSection(Writer writer, ChangesFileSection section) throws IOException {
        writer.write(section.getHeading());
        writer.write(LINE_SEPARATOR);
        for (String line : section.getContent()) {
            writer.write(line);
            writer.write(LINE_SEPARATOR);
        }
    }

    private static class Parser {
        final Path file;
        final BufferedReader reader;
        final ChangesFile.Builder builder = ChangesFile.builder();
        ChangesFileSection.Builder currentSection;
        int lineCount = 0;

        Parser(Path file, BufferedReader reader) {
            this.file = file;
            this.reader = reader;
        }

        ChangesFile parse() throws IOException {
            String line;
            while ((line = this.reader.readLine()) != null) {
                this.parseLine(line);
                ++this.lineCount;
            }
            this.addSection();
            return this.builder.build();
        }

        private void parseLine(String line) {
            if (this.lineCount == 0) {
                this.parseFirstLine(this.file, line);
                return;
            }
            if (line.startsWith(ChangesFileIO.CODE_NAME)) {
                this.builder.codeName(line.substring(ChangesFileIO.CODE_NAME.length()).trim());
                return;
            }
            if (line.startsWith("## ")) {
                this.addSection();
                this.currentSection = ChangesFileSection.builder(line);
                return;
            }
            if (this.currentSection != null) {
                this.currentSection.addLine(line);
            }
        }

        private void addSection() {
            if (this.currentSection == null) {
                return;
            }
            ChangesFileSection section = this.currentSection.build();
            this.currentSection = null;
            switch (section.getHeading()) {
                case "## Summary": {
                    this.builder.summary(section);
                    break;
                }
                case "## Dependency Updates": {
                    this.builder.dependencyChangeSection(section);
                    break;
                }
                default: {
                    this.builder.addSection(section);
                }
            }
        }

        private void parseFirstLine(Path filePath, String line) {
            Matcher matcher = FIRST_LINE_PATTERN.matcher(line);
            if (!matcher.matches()) {
                throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-171").message("Changes file {{file path}} contains invalid first line {{first line}}.", filePath, line).mitigation("Update first line so that it matches regex {{expected regular expression}}", FIRST_LINE_PATTERN).toString());
            }
            this.builder.projectName(matcher.group(1)).projectVersion(matcher.group(2)).releaseDate(matcher.group(3));
        }
    }
}

