/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.projectkeeper.mavenrepo.Version;
import com.vdurmont.semver4j.Semver;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ChangesFileName
implements Comparable<ChangesFileName> {
    public static final Pattern PATTERN = Pattern.compile("changes_(" + Version.PATTERN.pattern() + ")\\.md");
    private final Semver version;

    public static Optional<ChangesFileName> from(Path path) {
        String filename = path.getFileName().toString();
        Matcher matcher = PATTERN.matcher(filename);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(new ChangesFileName(matcher.replaceFirst("$1")));
    }

    public ChangesFileName(String version) {
        this.version = new Semver(version, Semver.SemverType.LOOSE);
    }

    public String filename() {
        return "changes_" + this.version + ".md";
    }

    @Override
    public int compareTo(ChangesFileName o) {
        return this.version.compareTo(o.version);
    }

    public String version() {
        return this.version.getValue();
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangesFileName other = (ChangesFileName)obj;
        return Objects.equals(this.version, other.version);
    }
}

