/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.projectkeeper.validators.changesfile.FixedIssue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class ChangesFileSection {
    private static final Pattern FIXED_ISSUE_LINE_REGEXP = Pattern.compile("[-*] #(\\d+) :? (.+)?".replace(" ", "\\s*"));
    private final String heading;
    private final List<String> content;

    private ChangesFileSection(Builder builder) {
        this.heading = Objects.requireNonNull(builder.heading, "header");
        this.content = List.copyOf(builder.lines);
    }

    public String getHeading() {
        return this.heading;
    }

    public List<String> getContent() {
        return this.content;
    }

    Stream<FixedIssue> getFixedIssues() {
        return this.content.stream().map(String::trim).map(this::findFixedIssue).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<FixedIssue> findFixedIssue(String line) {
        Matcher matcher = FIXED_ISSUE_LINE_REGEXP.matcher(line);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        int issueNumber = Integer.parseInt(matcher.group(1));
        String description = matcher.group(2);
        return Optional.of(new FixedIssue(issueNumber, description));
    }

    public int hashCode() {
        return Objects.hash(this.heading, this.content);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangesFileSection other = (ChangesFileSection)obj;
        return Objects.equals(this.heading, other.heading) && Objects.equals(this.content, other.content);
    }

    public String toString() {
        String text = this.heading + "\n" + String.join((CharSequence)"\n", this.content);
        return text.replaceAll("(?m)\n{3,}", "\n\n");
    }

    public static Builder builder(String heading) {
        return new Builder(heading);
    }

    public Builder toBuilder() {
        return ChangesFileSection.builder(this.heading).addLines(this.content);
    }

    public static class Builder {
        private final String heading;
        private final List<String> lines = new ArrayList<String>();

        private Builder(String heading) {
            this.heading = heading;
        }

        public Builder addLines(String ... lines) {
            this.lines.addAll(Arrays.asList(lines));
            return this;
        }

        public Builder addLines(List<String> lines) {
            this.lines.addAll(lines);
            return this;
        }

        public Builder addLine(String line) {
            this.lines.add(line);
            return this;
        }

        public ChangesFileSection build() {
            return new ChangesFileSection(this);
        }
    }
}

