/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.ExasolVersionMatcher;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.validators.AbstractFileValidator;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileIO;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import com.exasol.projectkeeper.validators.changesfile.DependencySectionFixer;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ChangesFileValidator
extends AbstractFileValidator {
    public static final String FEATURES_SECTION = "## Features";
    public static final String FIXED_ISSUE_TEMPLATE = "* ISSUE_NUMBER: description";
    private final String projectName;
    private final List<AnalyzedSource> sources;
    private final String projectVersion;
    private final ChangesFileIO changesFileIO;

    public ChangesFileValidator(String projectVersion, String projectName, Path projectDirectory, List<AnalyzedSource> sources) {
        this(projectVersion, projectName, projectDirectory, sources, new ChangesFileIO());
    }

    ChangesFileValidator(String projectVersion, String projectName, Path projectDirectory, List<AnalyzedSource> sources, ChangesFileIO changesFileIO) {
        super(projectDirectory, ChangesFile.getPathForVersion(projectVersion));
        this.projectVersion = projectVersion;
        this.projectName = projectName;
        this.sources = sources;
        this.changesFileIO = changesFileIO;
    }

    @Override
    protected void writeTemplateFile(Path target) {
        this.changesFileIO.write(this.getTemplate(), target);
    }

    @Override
    protected boolean isValidationEnabled() {
        return !new ExasolVersionMatcher().isSnapshotVersion(this.projectVersion);
    }

    @Override
    protected List<ValidationFinding> validateContent(Path file) {
        ChangesFile changesFile = this.changesFileIO.read(file);
        return Stream.of(this.validateDependencySection(file, changesFile), this.validateSummarySection(changesFile), this.validateProjectName(changesFile)).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private Optional<ValidationFinding> validateDependencySection(Path file, ChangesFile changesFile) {
        ChangesFile fixed = this.fixDependencyUpdateSection(changesFile);
        if (changesFile.equals(fixed)) {
            return this.noFinding();
        }
        return this.outdatedDependencySectionFinding(fixed, file);
    }

    private Optional<ValidationFinding> outdatedDependencySectionFinding(ChangesFile fixedSections, Path file) {
        String errorMessage = ExaError.messageBuilder("E-PK-CORE-40").message("Changes file is invalid.\nExpected content:\n{{expected content}}", new Object[0]).parameter("expected content", fixedSections.toString()).toString();
        SimpleValidationFinding.Fix fix = log -> this.changesFileIO.write(fixedSections, file);
        return Optional.of(SimpleValidationFinding.withMessage(errorMessage).andFix(fix).build());
    }

    private Optional<ValidationFinding> validateSummarySection(ChangesFile changesFile) {
        Optional<ChangesFileSection> summary = changesFile.getSummarySection();
        if (summary.isEmpty()) {
            return this.finding(ExaError.messageBuilder("E-PK-CORE-193").message("Section '## Summary' is missing in {{path}}.", this.relativeFilePath).mitigation("Add section.", new Object[0]).toString());
        }
        return this.noFinding();
    }

    private Optional<ValidationFinding> validateProjectName(ChangesFile changesFile) {
        if (changesFile.getProjectName() == null || changesFile.getProjectName().isBlank()) {
            return this.finding(ExaError.messageBuilder("E-PK-CORE-195").message("Project name in {{path}} is missing.", this.relativeFilePath).mitigation("Add a project name.", new Object[0]).toString());
        }
        return this.noFinding();
    }

    private Optional<ValidationFinding> finding(String message) {
        return Optional.of(SimpleValidationFinding.withMessage(message).build());
    }

    private Optional<ValidationFinding> noFinding() {
        return Optional.empty();
    }

    private ChangesFile fixDependencyUpdateSection(ChangesFile changesFile) {
        DependencySectionFixer dependencySectionFixer = new DependencySectionFixer(this.sources);
        return dependencySectionFixer.fix(changesFile);
    }

    private ChangesFile getTemplate() {
        String releaseDate = LocalDateTime.now().getYear() + "-??-??";
        ChangesFile changesFile = ChangesFile.builder().projectName(this.projectName).projectVersion(this.projectVersion).releaseDate(releaseDate).codeName("").summary(ChangesFileSection.builder("## Summary").build()).addSection(ChangesFileSection.builder(FEATURES_SECTION).addLines("", FIXED_ISSUE_TEMPLATE, "").build()).build();
        return this.fixDependencyUpdateSection(changesFile);
    }
}

