/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import com.exasol.projectkeeper.validators.changesfile.NamedDependencyChangeReport;
import com.exasol.projectkeeper.validators.changesfile.dependencies.DependencyChangeReportRenderer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class DependencySectionFixer {
    private final List<AnalyzedSource> sources;

    public DependencySectionFixer(List<AnalyzedSource> sources) {
        this.sources = sources;
    }

    public ChangesFile fix(ChangesFile changesFile) {
        List<NamedDependencyChangeReport> reports = this.sources.stream().map(this::getDependencyChangesOfSource).collect(Collectors.toList());
        Optional<ChangesFileSection> dependencyChanges = new DependencyChangeReportRenderer().render(reports);
        return changesFile.toBuilder().dependencyChangeSection(dependencyChanges.orElse(null)).build();
    }

    private NamedDependencyChangeReport getDependencyChangesOfSource(AnalyzedSource source) {
        return new NamedDependencyChangeReport(source.getProjectName(), source.getDependencyChanges());
    }
}

