/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.pom.MavenProjectFromFileReader;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeReport;
import com.exasol.projectkeeper.validators.changesfile.LastReleasePomFileReader;
import com.exasol.projectkeeper.validators.changesfile.dependencies.DependencyChangeReportReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;

public class DependencyUpdateReader {
    private final MavenProjectFromFileReader mavenModelReader;
    private final Path projectDirectory;
    private final Model currentMavenModel;

    public DependencyUpdateReader(MavenProjectFromFileReader mavenModelReader, Path projectDirectory, Model currentMavenModel) {
        this.mavenModelReader = mavenModelReader;
        this.projectDirectory = projectDirectory;
        this.currentMavenModel = currentMavenModel;
    }

    public DependencyChangeReport readDependencyChanges() {
        return new DependencyChangeReportReader().read(this.getOldModel(), this.currentMavenModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getOldModel() {
        Path relativePathToPom = this.projectDirectory.relativize(this.currentMavenModel.getPomFile().toPath());
        Path tempDirectory = this.createTempDirectory();
        try {
            Optional<Path> lastReleasesPomFile = new LastReleasePomFileReader().extractLatestReleasesPomFile(this.projectDirectory, relativePathToPom, this.currentMavenModel.getVersion(), tempDirectory);
            if (lastReleasesPomFile.isPresent()) {
                Model model = this.parseOldPomFile(lastReleasesPomFile.get());
                return model;
            }
            Model model = this.emptyModel();
            return model;
        }
        finally {
            this.deleteTempDir(tempDirectory);
        }
    }

    private Model emptyModel() {
        Model emptyModel = new Model();
        emptyModel.setBuild(new Build());
        return emptyModel;
    }

    private void deleteTempDir(Path tempDirectory) {
        try {
            if (Files.isDirectory(tempDirectory, new LinkOption[0])) {
                try (Stream<Path> contentStream = Files.list(tempDirectory);){
                    contentStream.forEach(this::deleteTempDir);
                }
            }
            Files.delete(tempDirectory);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-MPC-63").message("Failed to delete the temp directory we created for buffering the pom file of the previous release.", new Object[0]).toString(), exception);
        }
    }

    private Path createTempDirectory() {
        try {
            return Files.createTempDirectory("pk-pom-buffer", new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-MPC-62").message("Failed to create a temp directory for buffering the pom file of the previous release.", new Object[0]).toString(), exception);
        }
    }

    private Model parseOldPomFile(Path pomFile) {
        try {
            return this.mavenModelReader.readProject(pomFile.toFile()).getModel();
        }
        catch (MavenProjectFromFileReader.ReadFailedException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-MPC-38").message("Failed to parse pom file of previous release.", new Object[0]).toString(), exception);
        }
    }
}

