/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.repository.GitRepository;
import com.exasol.projectkeeper.shared.repository.TaggedCommit;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class LastReleasePomFileReader {
    private static final Logger LOGGER = Logger.getLogger(LastReleasePomFileReader.class.getName());

    public Optional<Path> extractLatestReleasesPomFile(Path projectDirectory, Path relativePathToPom, String currentVersion, Path targetDirectory) {
        Path gitRepo = this.findGitRepo(projectDirectory);
        Path relativeProjectDirPath = gitRepo.relativize(projectDirectory);
        try (GitRepository gitRepository = GitRepository.open(gitRepo);){
            Optional<TaggedCommit> latestReleaseCommit = gitRepository.findLatestReleaseCommit(currentVersion);
            if (latestReleaseCommit.isEmpty()) {
                Optional<Path> optional = Optional.empty();
                return optional;
            }
            Path pathToPomRelativeToGit = relativeProjectDirPath.resolve(relativePathToPom);
            Optional<Path> pomFile = this.extractPomFile(gitRepository, latestReleaseCommit.get(), pathToPomRelativeToGit, targetDirectory);
            pomFile.ifPresent(path -> this.extractParentStack(targetDirectory, gitRepository, (TaggedCommit)latestReleaseCommit.get(), projectDirectory.resolve(relativePathToPom), (Path)path, gitRepo));
            Optional<Path> optional = pomFile;
            return optional;
        }
    }

    private void extractParentStack(Path targetDirectory, GitRepository gitRepository, TaggedCommit latestCommitWithExasolVersionTag, Path pathToPom, Path extractedPomFile, Path pathToGitRepo) {
        Path currentPomPath = pathToPom;
        Parent parentRef = this.readPomFile(extractedPomFile).getParent();
        while (parentRef != null && parentRef.getRelativePath() != null && !parentRef.getRelativePath().isBlank()) {
            Path pathRelativeToGitRepo = pathToGitRepo.relativize(currentPomPath = currentPomPath.getParent().resolve(parentRef.getRelativePath()).normalize());
            Optional<Path> parentPom = this.extractPomFile(gitRepository, latestCommitWithExasolVersionTag, pathRelativeToGitRepo, targetDirectory);
            if (parentPom.isEmpty()) {
                throw new IllegalStateException(ExaError.messageBuilder("E-PK-MPC-61").message("Failed to extract the parent pom {{path}} fom git history.", currentPomPath).toString());
            }
            parentRef = this.readPomFile(parentPom.get()).getParent();
        }
    }

    private Model readPomFile(Path pomFile) {
        Model model;
        FileReader fileReader = new FileReader(pomFile.toFile());
        try {
            model = new MavenXpp3Reader().read(fileReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XmlPullParserException exception) {
                throw new IllegalStateException(ExaError.messageBuilder("E-PK-MPC-60").message("Failed to read pom file of previous version for extracting it's parent.", new Object[0]).toString(), exception);
            }
        }
        fileReader.close();
        return model;
    }

    private Path findGitRepo(Path projectDirectory) {
        Path currentDir = projectDirectory;
        while (!Files.exists(currentDir.resolve(".git"), new LinkOption[0])) {
            currentDir = currentDir.getParent();
        }
        return currentDir;
    }

    private Optional<Path> extractPomFile(GitRepository gitRepository, TaggedCommit taggedCommit, Path pathToPom, Path targetDirectory) {
        try {
            Path targetFile = targetDirectory.resolve(pathToPom);
            gitRepository.extractFileFromCommit(pathToPom, taggedCommit.getCommit(), targetFile);
            return Optional.of(targetFile);
        }
        catch (FileNotFoundException exception) {
            LOGGER.warning("Could not read pom file from previous release. Assuming empty file.");
            return Optional.empty();
        }
    }
}

