/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile.dependencies;

import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeVisitor;
import com.exasol.projectkeeper.shared.dependencychanges.NewDependency;
import com.exasol.projectkeeper.shared.dependencychanges.RemovedDependency;
import com.exasol.projectkeeper.shared.dependencychanges.UpdatedDependency;

class DependencyChangeRenderer {
    DependencyChangeRenderer() {
    }

    public String render(DependencyChange dependencyChange) {
        RenderVisitor visitor = new RenderVisitor();
        dependencyChange.accept(visitor);
        return visitor.getRendered();
    }

    private static class RenderVisitor
    implements DependencyChangeVisitor {
        private String rendered;

        private RenderVisitor() {
        }

        @Override
        public void visit(NewDependency addedDependency) {
            this.rendered = "* Added " + this.renderDependencyChange(addedDependency);
        }

        @Override
        public void visit(RemovedDependency removedDependency) {
            this.rendered = "* Removed " + this.renderDependencyChange(removedDependency);
        }

        @Override
        public void visit(UpdatedDependency updatedDependency) {
            this.rendered = "* Updated " + this.renderDependencyChange(updatedDependency) + " to `" + updatedDependency.getNewVersion() + "`";
        }

        private String renderDependencyChange(DependencyChange addedDependency) {
            String groupId = addedDependency.getGroupId();
            return "`" + (String)(groupId != null ? groupId + ":" : "") + addedDependency.getArtifactId() + ":" + addedDependency.getVersion() + "`";
        }

        public String getRendered() {
            return this.rendered;
        }
    }
}

