/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile.dependencies;

import com.exasol.projectkeeper.ApStyleFormatter;
import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeReport;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import com.exasol.projectkeeper.validators.changesfile.NamedDependencyChangeReport;
import com.exasol.projectkeeper.validators.changesfile.dependencies.DependencyChangeRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DependencyChangeReportRenderer {
    public Optional<ChangesFileSection> render(List<NamedDependencyChangeReport> reports) {
        List<String> content = this.renderContent(reports);
        if (content.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ChangesFileSection.builder("## Dependency Updates").addLines(content).build());
    }

    private List<String> renderContent(List<NamedDependencyChangeReport> reports) {
        ArrayList<String> content = new ArrayList<String>();
        boolean isMultiReports = reports.size() > 1;
        for (NamedDependencyChangeReport report : reports) {
            content.addAll(this.renderProject(report, isMultiReports));
        }
        return content;
    }

    private List<String> renderProject(NamedDependencyChangeReport namedReport, boolean isMultiReports) {
        ArrayList<String> lines = new ArrayList<String>();
        DependencyChangeReport report = namedReport.getReport();
        String headlinePrefix = isMultiReports ? "#### " : "### ";
        for (BaseDependency.Type type : BaseDependency.Type.values()) {
            lines.addAll(this.renderDependencyChanges(headlinePrefix + type.getHeader(), report.getChanges(type)));
        }
        if (!lines.isEmpty() && isMultiReports) {
            lines.addAll(0, List.of("", "### " + ApStyleFormatter.capitalizeApStyle(namedReport.getSourceName())));
        }
        return lines;
    }

    private List<String> renderDependencyChanges(String heading, List<DependencyChange> dependencyChanges) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!dependencyChanges.isEmpty()) {
            lines.add("");
            lines.add(heading);
            lines.add("");
            DependencyChangeRenderer dependencyChangeRenderer = new DependencyChangeRenderer();
            for (DependencyChange dependencyChange : dependencyChanges) {
                lines.add(dependencyChangeRenderer.render(dependencyChange));
            }
        }
        return lines;
    }
}

