/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile.dependencies;

import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import com.exasol.projectkeeper.shared.dependencychanges.NewDependency;
import com.exasol.projectkeeper.shared.dependencychanges.RemovedDependency;
import com.exasol.projectkeeper.shared.dependencychanges.UpdatedDependency;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;

public class MavenDependencyComparator {
    public List<DependencyChange> compare(List<Dependency> oldDependencies, List<Dependency> newDependencies) {
        ArrayList<DependencyChange> report = new ArrayList<DependencyChange>();
        Map<String, Dependency> oldDependenciesMap = this.createMapWithDependencyKey(oldDependencies);
        Map<String, Dependency> newDependenciesMap = this.createMapWithDependencyKey(newDependencies);
        this.findOutWhatHappenedToDependenciesOfPreviousRelease(report, oldDependenciesMap, newDependenciesMap);
        this.checkIfThisReleaseHasNewDependencies(report, oldDependenciesMap, newDependenciesMap);
        return report;
    }

    private void checkIfThisReleaseHasNewDependencies(List<DependencyChange> report, Map<String, Dependency> oldDependenciesMap, Map<String, Dependency> newDependenciesMap) {
        newDependenciesMap.forEach((key, newDependency) -> {
            if (!oldDependenciesMap.containsKey(key)) {
                this.addAddedDependency(report, (Dependency)newDependency);
            }
        });
    }

    private void findOutWhatHappenedToDependenciesOfPreviousRelease(List<DependencyChange> report, Map<String, Dependency> oldDependenciesMap, Map<String, Dependency> newDependenciesMap) {
        oldDependenciesMap.forEach((key, oldDependency) -> {
            if (newDependenciesMap.containsKey(key)) {
                this.addUpdatedDependencyIfVersionChanged(report, (Dependency)newDependenciesMap.get(key), (Dependency)oldDependency);
            } else {
                this.addRemovedDependency(report, (Dependency)oldDependency);
            }
        });
    }

    private void addAddedDependency(List<DependencyChange> report, Dependency newDependency) {
        report.add(new NewDependency(newDependency.getGroupId(), newDependency.getArtifactId(), newDependency.getVersion()));
    }

    private void addRemovedDependency(List<DependencyChange> report, Dependency oldDependency) {
        report.add(new RemovedDependency(oldDependency.getGroupId(), oldDependency.getArtifactId(), oldDependency.getVersion()));
    }

    private void addUpdatedDependencyIfVersionChanged(List<DependencyChange> report, Dependency newDependency, Dependency oldDependency) {
        String newDependencyVersion = newDependency.getVersion();
        if (newDependencyVersion != null && !newDependencyVersion.equals(oldDependency.getVersion())) {
            report.add(new UpdatedDependency(oldDependency.getGroupId(), oldDependency.getArtifactId(), oldDependency.getVersion(), newDependencyVersion));
        }
    }

    private Map<String, Dependency> createMapWithDependencyKey(List<Dependency> dependencies) {
        return dependencies.stream().collect(Collectors.toMap(this::buildDependencyKey, each -> each));
    }

    private String buildDependencyKey(Dependency each) {
        return each.getGroupId() + each.getArtifactId();
    }
}

