/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.dependencies;

import com.exasol.projectkeeper.BrokenLinkReplacer;
import com.exasol.projectkeeper.shared.dependencies.License;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependency;
import com.exasol.projectkeeper.validators.dependencies.ProjectWithDependencies;
import java.util.List;
import java.util.stream.Collectors;

public class DependenciesBrokenLinkReplacer {
    private final BrokenLinkReplacer brokenLinkReplacer;

    public DependenciesBrokenLinkReplacer(BrokenLinkReplacer brokenLinkReplacer) {
        this.brokenLinkReplacer = brokenLinkReplacer;
    }

    public ProjectWithDependencies replaceBrokenLinks(ProjectWithDependencies projectWithDependencies) {
        List<ProjectDependency> fixedDependencies = projectWithDependencies.getDependencies().stream().map(this::replaceBrokenLinks).collect(Collectors.toList());
        return projectWithDependencies.withDependencies(fixedDependencies);
    }

    private ProjectDependency replaceBrokenLinks(ProjectDependency dependency) {
        return ProjectDependency.builder().type(dependency.getType()).name(dependency.getName()).websiteUrl(this.brokenLinkReplacer.replaceIfBroken(dependency.getWebsiteUrl())).licenses(this.replaceBrokenLicenseLinks(dependency.getLicenses())).build();
    }

    private List<License> replaceBrokenLicenseLinks(List<License> licenses) {
        return licenses.stream().map(this::replaceBrokenLicenseLinks).collect(Collectors.toList());
    }

    private License replaceBrokenLicenseLinks(License license) {
        return new License(license.getName(), this.brokenLinkReplacer.replaceIfBroken(license.getUrl()));
    }
}

