/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.dependencies;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.BrokenLinkReplacer;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependency;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.validators.dependencies.DependenciesBrokenLinkReplacer;
import com.exasol.projectkeeper.validators.dependencies.ProjectWithDependencies;
import com.exasol.projectkeeper.validators.dependencies.renderer.DependencyPageRenderer;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DependenciesValidator
implements Validator {
    private final Path dependenciesFile;
    private final List<AnalyzedSource> sources;
    private final BrokenLinkReplacer brokenLinkReplacer;

    public DependenciesValidator(List<AnalyzedSource> sources, Path projectDirectory, BrokenLinkReplacer brokenLinkReplacer) {
        this.sources = sources;
        this.brokenLinkReplacer = brokenLinkReplacer;
        this.dependenciesFile = projectDirectory.resolve("dependencies.md");
    }

    @Override
    public List<ValidationFinding> validate() {
        String expectedDependenciesPage = this.generateExpectedReport();
        if (!this.dependenciesFile.toFile().exists()) {
            return List.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder("E-PK-CORE-50").message("This project does not have a dependencies.md file.", new Object[0]).toString()).andFix(this.getFix(expectedDependenciesPage)).build());
        }
        return this.validateFileContent(expectedDependenciesPage);
    }

    private String generateExpectedReport() {
        DependenciesBrokenLinkReplacer dependencyLinkReplacer = new DependenciesBrokenLinkReplacer(this.brokenLinkReplacer);
        List<ProjectWithDependencies> dependencies = this.sources.stream().map(this::getDependencies).map(dependencyLinkReplacer::replaceBrokenLinks).collect(Collectors.toList());
        return new DependencyPageRenderer().render(dependencies);
    }

    private ProjectWithDependencies getDependencies(AnalyzedSource source) {
        String projectName = source.getProjectName();
        List<ProjectDependency> dependencies = source.getDependencies().getDependencies();
        return new ProjectWithDependencies(projectName, dependencies);
    }

    private List<ValidationFinding> validateFileContent(String expectedDependenciesPage) {
        try {
            String actualContent = Files.readString(this.dependenciesFile);
            if (!actualContent.equals(expectedDependenciesPage)) {
                return List.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder("E-PK-CORE-53").message("The dependencies.md file has outdated content.\nExpected content:\n{{expected content|u}}", expectedDependenciesPage).toString()).andFix(this.getFix(expectedDependenciesPage)).build());
            }
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-52").message("Failed to read dependencies.md for validation.", new Object[0]).toString(), exception);
        }
        return Collections.emptyList();
    }

    private SimpleValidationFinding.Fix getFix(String expectedDependenciesPage) {
        return log -> {
            try {
                Files.writeString(this.dependenciesFile, (CharSequence)expectedDependenciesPage, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-51").message("Failed to write dependencies.md file.", new Object[0]).toString(), exception);
            }
        };
    }
}

