/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.dependencies;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.pom.MavenModelFromRepositoryReader;
import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencies.License;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependencies;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependency;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;

public class ProjectDependencyReader {
    private final MavenModelFromRepositoryReader artifactModelReader;
    private final MavenProject project;

    public ProjectDependencyReader(MavenModelFromRepositoryReader artifactModelReader, MavenProject project) {
        this.artifactModelReader = artifactModelReader;
        this.project = project;
    }

    public ProjectDependencies readDependencies() {
        List<ProjectDependency> dependencies = this.getDependenciesIncludingPlugins().map(dependency -> this.getLicense((Dependency)dependency, this.project)).collect(Collectors.toList());
        return new ProjectDependencies(dependencies);
    }

    private Stream<Dependency> getDependenciesIncludingPlugins() {
        return Stream.concat(this.getDependencies(), this.getPluginDependencies());
    }

    private Stream<Dependency> getDependencies() {
        return this.project.getModel().getDependencies().stream();
    }

    private Stream<Dependency> getPluginDependencies() {
        return this.project.getModel().getBuild().getPlugins().stream().filter(this::isExplicitPlugin).map(this::convertPluginToDependency);
    }

    private boolean isExplicitPlugin(Plugin plugin) {
        String location = plugin.getLocation("").getSource().getLocation();
        return location != null;
    }

    private Dependency convertPluginToDependency(Plugin plugin) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(plugin.getGroupId());
        dependency.setArtifactId(plugin.getArtifactId());
        dependency.setVersion(plugin.getVersion());
        dependency.setScope("plugin");
        return dependency;
    }

    private ProjectDependency getLicense(Dependency dependency, MavenProject project) {
        try {
            List repos = project.getRemoteArtifactRepositories();
            Model dependenciesPom = this.artifactModelReader.readModel(dependency.getArtifactId(), dependency.getGroupId(), dependency.getVersion(), repos);
            List<License> licenses = dependenciesPom.getLicenses().stream().map(license -> new License(license.getName(), license.getUrl())).collect(Collectors.toList());
            return ProjectDependency.builder().type(this.mapScopeToDependencyType(dependency.getScope())).name(this.getDependencyName(dependenciesPom)).websiteUrl(dependenciesPom.getUrl()).licenses(licenses).build();
        }
        catch (ProjectBuildingException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-MPC-49").message("Failed to get license information for dependency {{groupId}}:{{artifactId}}.", dependency.getGroupId(), dependency.getArtifactId()).toString(), exception);
        }
    }

    private String getDependencyName(Model dependenciesPom) {
        if (dependenciesPom.getName() == null || dependenciesPom.getName().isBlank()) {
            return dependenciesPom.getArtifactId();
        }
        return dependenciesPom.getName();
    }

    private BaseDependency.Type mapScopeToDependencyType(String scope) {
        if (scope == null) {
            return BaseDependency.Type.COMPILE;
        }
        switch (scope) {
            case "compile": 
            case "provided": 
            case "system": 
            case "import": {
                return BaseDependency.Type.COMPILE;
            }
            case "test": {
                return BaseDependency.Type.TEST;
            }
            case "runtime": {
                return BaseDependency.Type.RUNTIME;
            }
            case "plugin": {
                return BaseDependency.Type.PLUGIN;
            }
        }
        throw new IllegalStateException(ExaError.messageBuilder("F-PK-MPC-54").message("Unimplemented dependency scope {{scope}}.", scope).ticketMitigation().toString());
    }
}

