/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.dependencies.renderer;

import com.exasol.projectkeeper.ApStyleFormatter;
import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencies.License;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependency;
import com.exasol.projectkeeper.validators.dependencies.ProjectWithDependencies;
import com.exasol.projectkeeper.validators.dependencies.renderer.MarkdownReferenceBuilder;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.steppschuh.markdowngenerator.table.Table;

public class DependencyPageRenderer {
    private static final String NEWLINE = System.lineSeparator();

    public String render(List<ProjectWithDependencies> projectWithDependencies) {
        MarkdownReferenceBuilder markdownReferenceBuilder = new MarkdownReferenceBuilder();
        StringBuilder reportBuilder = new StringBuilder();
        reportBuilder.append("<!-- @formatter:off -->" + NEWLINE);
        reportBuilder.append("# Dependencies" + NEWLINE);
        for (ProjectWithDependencies project : projectWithDependencies) {
            boolean isMultiSourceProject = projectWithDependencies.size() > 1;
            reportBuilder.append(this.buildDependencySectionForProject(project, markdownReferenceBuilder, isMultiSourceProject));
        }
        reportBuilder.append(NEWLINE);
        reportBuilder.append(markdownReferenceBuilder.getReferences());
        return reportBuilder.toString();
    }

    private String buildDependencySectionForProject(ProjectWithDependencies project, MarkdownReferenceBuilder markdownRefBuilder, boolean isMultiProject) {
        StringBuilder reportBuilder = new StringBuilder();
        if (isMultiProject) {
            reportBuilder.append(NEWLINE + this.makeHeadline(project.getProjectName(), 2) + NEWLINE);
        }
        List<ProjectDependency> dependencies = project.getDependencies();
        int headlineLevel = isMultiProject ? 3 : 2;
        reportBuilder.append(this.buildDependencySectionForScope(dependencies, BaseDependency.Type.COMPILE, markdownRefBuilder, headlineLevel));
        reportBuilder.append(this.buildDependencySectionForScope(dependencies, BaseDependency.Type.TEST, markdownRefBuilder, headlineLevel));
        reportBuilder.append(this.buildDependencySectionForScope(dependencies, BaseDependency.Type.RUNTIME, markdownRefBuilder, headlineLevel));
        reportBuilder.append(this.buildDependencySectionForScope(dependencies, BaseDependency.Type.PLUGIN, markdownRefBuilder, headlineLevel));
        return reportBuilder.toString();
    }

    private String buildDependencySectionForScope(List<ProjectDependency> dependencies, BaseDependency.Type type, MarkdownReferenceBuilder markdownReferenceBuilder, int headlineLevel) {
        List<ProjectDependency> dependenciesOfThisScope = dependencies.stream().filter(dependency -> dependency.getType().equals((Object)type)).collect(Collectors.toList());
        if (dependenciesOfThisScope.isEmpty()) {
            return "";
        }
        String heading = this.makeHeadline(type.name() + " Dependencies", headlineLevel);
        return NEWLINE + heading + NEWLINE + NEWLINE + this.buildTable(dependenciesOfThisScope, markdownReferenceBuilder) + NEWLINE;
    }

    private String makeHeadline(String text, int level) {
        return "#".repeat(level) + " " + ApStyleFormatter.capitalizeApStyle(text.toLowerCase(Locale.ROOT));
    }

    private String buildTable(List<ProjectDependency> dependencies, MarkdownReferenceBuilder markdownReferenceBuilder) {
        Table.Builder tableBuilder = new Table.Builder().withAlignments(2, 2);
        tableBuilder.addRow("Dependency", "License");
        dependencies.forEach(dependency -> {
            String name = this.renderDependencyName((ProjectDependency)dependency, markdownReferenceBuilder);
            String licenseText = dependency.getLicenses().stream().map(license -> this.renderLicense((License)license, markdownReferenceBuilder)).collect(Collectors.joining("; "));
            tableBuilder.addRow(name, licenseText);
        });
        return tableBuilder.build().toString();
    }

    private String renderDependencyName(ProjectDependency dependency, MarkdownReferenceBuilder markdownReferenceBuilder) {
        return this.renderLink(dependency.getName(), dependency.getWebsiteUrl(), markdownReferenceBuilder);
    }

    private String renderLicense(License license, MarkdownReferenceBuilder markdownReferenceBuilder) {
        return this.renderLink(license.getName(), license.getUrl(), markdownReferenceBuilder);
    }

    private String renderLink(String name, String url, MarkdownReferenceBuilder markdownReferenceBuilder) {
        if (url == null || url.isBlank()) {
            return name;
        }
        return "[" + DependencyPageRenderer.escapeTableContent(name) + "][" + markdownReferenceBuilder.getReferenceForUrl(url) + "]";
    }

    private static String escapeTableContent(String text) {
        return text.replace("|", "\\|");
    }
}

