/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.dependencies.renderer;

import java.util.LinkedHashMap;
import java.util.Map;

class MarkdownReferenceBuilder {
    private final Map<String, Integer> references = new LinkedHashMap<String, Integer>();
    private int referenceCounter = 0;

    MarkdownReferenceBuilder() {
    }

    public String getReferenceForUrl(String url) {
        if (!this.references.containsKey(url)) {
            this.references.put(url, this.referenceCounter);
            String key = String.valueOf(this.referenceCounter);
            ++this.referenceCounter;
            return key;
        }
        return String.valueOf(this.references.get(url));
    }

    public String getReferences() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> ref : this.references.entrySet()) {
            sb.append(String.format("[%s]: %s%s", ref.getValue(), ref.getKey(), System.lineSeparator()));
        }
        return sb.toString();
    }
}

