/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.projectkeeper.shared.config.BuildOptions;
import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.shared.config.workflow.CustomWorkflow;
import com.exasol.projectkeeper.shared.config.workflow.StepCustomization;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.validators.files.ContentCustomizingTemplate;
import com.exasol.projectkeeper.validators.files.FileTemplate;
import com.exasol.projectkeeper.validators.files.FileTemplateFromResource;
import com.exasol.projectkeeper.validators.files.GitHubWorkflowCustomizer;
import com.exasol.projectkeeper.validators.files.GitHubWorkflowEnvironmentCustomizer;
import com.exasol.projectkeeper.validators.files.GitHubWorkflowStepCustomizer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class CiBuildWorkflowGenerator {
    private static final String WORKFLOW_PATH = ".github/workflows/";
    private static final String CI_BUILD_WORKFLOW_NAME = "ci-build.yml";
    private static final String CI_BUILD_PATH_IN_PROJECT = ".github/workflows/ci-build.yml";
    private final BuildOptions buildOptions;

    CiBuildWorkflowGenerator(BuildOptions buildOptions) {
        this.buildOptions = buildOptions;
    }

    FileTemplate createCiBuildWorkflow() {
        CiTemplateType buildType = this.getCiBuildType();
        String templateResource = "templates/.github/workflows/" + buildType.templateName;
        FileTemplateFromResource template = new FileTemplateFromResource(templateResource, CI_BUILD_PATH_IN_PROJECT, FileTemplate.Validation.REQUIRE_EXACT);
        template.replacing("ciBuildRunnerOS", this.buildOptions.getRunnerOs());
        template.replacing("freeDiskSpace", String.valueOf(this.buildOptions.shouldFreeDiskSpace()));
        if (buildType == CiTemplateType.EXASOL_VERSION_MATRIX) {
            template.replacing("matrixExasolDbVersions", this.buildOptions.getExasolDbVersions().stream().map(this::quote).collect(Collectors.joining(", ")));
            template.replacing("defaultExasolDbVersion", this.quote(this.buildOptions.getExasolDbVersions().get(0)));
        }
        String buildJobId = buildType.buildJobId;
        return this.createTemplate(template, CI_BUILD_WORKFLOW_NAME, buildJobId);
    }

    private FileTemplate createTemplate(FileTemplateFromResource template, String workflowName, String buildJobId) {
        Optional<CustomWorkflow> workflow = this.buildOptions.getWorkflow(workflowName);
        List customizations = workflow.map(CustomWorkflow::getSteps).orElseGet(Collections::emptyList);
        String environmentName = workflow.map(CustomWorkflow::getEnvironment).orElse(null);
        return new ContentCustomizingTemplate(template, new GitHubWorkflowCustomizer(new GitHubWorkflowStepCustomizer(customizations, buildJobId), new GitHubWorkflowEnvironmentCustomizer(buildJobId, environmentName)));
    }

    private List<StepCustomization> findCustomizations(String workflowName) {
        return this.buildOptions.getWorkflow(workflowName).map(CustomWorkflow::getSteps).orElseGet(Collections::emptyList);
    }

    private String quote(String value) {
        return "\"" + value + "\"";
    }

    private CiTemplateType getCiBuildType() {
        if (!this.buildOptions.getExasolDbVersions().isEmpty()) {
            return CiTemplateType.EXASOL_VERSION_MATRIX;
        }
        return CiTemplateType.DEFAULT;
    }

    FileTemplate createReleaseWorkflow(List<AnalyzedSource> sources) {
        Consumer<FileTemplateFromResource> templateCustomizer = template -> template.replacing("mavenCentralDeployment", this.mavenCentralDeploymentRequired(sources) ? "true" : "false");
        return this.createCustomizedWorkflow("release.yml", "release", templateCustomizer);
    }

    private boolean mavenCentralDeploymentRequired(List<AnalyzedSource> sources) {
        return sources.stream().map(AnalyzedSource::getModules).filter(Objects::nonNull).flatMap(Collection::stream).anyMatch(ProjectKeeperModule.MAVEN_CENTRAL::equals);
    }

    FileTemplate createDependenciesCheckWorkflow() {
        return this.createCustomizedWorkflow("dependencies_check.yml", "report_security_issues");
    }

    FileTemplate createDependenciesUpdateWorkflow() {
        return this.createCustomizedWorkflow("dependencies_update.yml", "update_dependencies");
    }

    private FileTemplate createCustomizedWorkflow(String workflowName, String jobName) {
        return this.createCustomizedWorkflow(workflowName, jobName, template -> {});
    }

    private FileTemplate createCustomizedWorkflow(String workflowName, String jobName, Consumer<FileTemplateFromResource> templateCustomizer) {
        FileTemplateFromResource template = new FileTemplateFromResource(WORKFLOW_PATH + workflowName, FileTemplate.Validation.REQUIRE_EXACT);
        templateCustomizer.accept(template);
        List<StepCustomization> customizations = this.findCustomizations(workflowName);
        return new ContentCustomizingTemplate(template, new GitHubWorkflowCustomizer(new GitHubWorkflowStepCustomizer(customizations, jobName)));
    }

    static enum CiTemplateType {
        DEFAULT("ci-build.yml", "build"),
        EXASOL_VERSION_MATRIX("ci-build-db-version-matrix.yml", "matrix-build");

        private final String templateName;
        private final String buildJobId;

        private CiTemplateType(String templateName, String buildJobId) {
            this.templateName = templateName;
            this.buildJobId = buildJobId;
        }
    }
}

