/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.files.FileTemplate;
import com.exasol.projectkeeper.validators.files.ResourceReader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class FileTemplateFromResource
implements FileTemplate {
    private final String templateResource;
    private final String pathInProject;
    private final FileTemplate.Validation validation;
    private final Map<String, String> replacements = new HashMap<String, String>();

    public FileTemplateFromResource(String pathInProject, FileTemplate.Validation validation) {
        this("templates/" + pathInProject, pathInProject, validation);
    }

    public FileTemplateFromResource(String templateResource, String pathInProject, FileTemplate.Validation validation) {
        this.templateResource = templateResource;
        this.pathInProject = pathInProject;
        this.validation = validation;
    }

    public FileTemplateFromResource replacing(String name, String replacement) {
        if (this.replacements.containsKey(name)) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-170").message("Cannot add replacement with value {{new replacement}} because {{name}} is already registered as replacement with value {{existing value}}.", replacement, name, this.replacements.get(name)).mitigation("Remove or rename one of the replacements.", new Object[0]).toString());
        }
        this.replacements.put(name, replacement);
        return this;
    }

    @Override
    public Path getPathInProject() {
        return Path.of(this.pathInProject, new String[0]);
    }

    @Override
    public String getContent() {
        String value = new ResourceReader().readFromResource(this.templateResource);
        for (Map.Entry<String, String> rep : this.replacements.entrySet()) {
            value = this.replacePlaceholder(value, rep);
        }
        return value;
    }

    private String replacePlaceholder(String value, Map.Entry<String, String> rep) {
        String newValue = value.replace("$" + rep.getKey(), rep.getValue());
        if (value.equals(newValue)) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-169").message("Placeholder {{placeholder}} not found in template {{template}}.", rep.getKey(), this.templateResource).ticketMitigation().toString());
        }
        return newValue;
    }

    @Override
    public FileTemplate.Validation getValidation() {
        return this.validation;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.templateResource, this.pathInProject, this.validation, this.replacements});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileTemplateFromResource other = (FileTemplateFromResource)obj;
        return Objects.equals(this.templateResource, other.templateResource) && Objects.equals(this.pathInProject, other.pathInProject) && this.validation == other.validation && Objects.equals(this.replacements, other.replacements);
    }
}

