/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.config.workflow.WorkflowStep;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.IntStream;

class GitHubWorkflow {
    private static final Logger LOG = Logger.getLogger(GitHubWorkflow.class.getName());
    private final Map<String, Object> rawWorkflow;

    private GitHubWorkflow(Map<String, Object> rawWorkflow) {
        this.rawWorkflow = rawWorkflow;
    }

    static GitHubWorkflow create(Object rawWorkflow) {
        return new GitHubWorkflow(GitHubWorkflow.asMap(rawWorkflow));
    }

    private static Map<String, Object> asMap(Object rawYaml) {
        return (Map)rawYaml;
    }

    Job getJob(String jobId) {
        Object rawJob = this.getJobs().get(jobId);
        if (rawJob == null) {
            return null;
        }
        return new Job(GitHubWorkflow.asMap(rawJob));
    }

    private Map<String, Object> getJobs() {
        return GitHubWorkflow.asMap(this.rawWorkflow.get("jobs"));
    }

    Map<String, Object> getOnTrigger() {
        return GitHubWorkflow.asMap(this.rawWorkflow.get("on"));
    }

    Object getRawObject() {
        return this.rawWorkflow;
    }

    static class Job {
        private final Map<String, Object> rawJob;

        private Job(Map<String, Object> rawJob) {
            this.rawJob = rawJob;
        }

        Step getStep(String id) {
            return this.getSteps().stream().filter(this.hasId(id)).findFirst().orElseThrow(() -> new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-206").message("Job has no step with ID {{step id}}: {{raw job}}", id, this.rawJob).toString()));
        }

        List<Step> getSteps() {
            return this.getRawSteps().stream().map(Step::new).toList();
        }

        private List<Map<String, Object>> getRawSteps() {
            Object steps = this.rawJob.get("steps");
            if (steps == null) {
                return Collections.emptyList();
            }
            return (List)steps;
        }

        String getRunnerOS() {
            return (String)this.rawJob.get("runs-on");
        }

        Map<String, Object> getConcurrency() {
            return GitHubWorkflow.asMap(this.rawJob.get("concurrency"));
        }

        Map<String, Object> getStrategy() {
            return GitHubWorkflow.asMap(this.rawJob.get("strategy"));
        }

        Map<String, Object> getEnv() {
            return GitHubWorkflow.asMap(this.rawJob.get("env"));
        }

        public String getEnvironment() {
            return (String)this.rawJob.get("environment");
        }

        public void setEnvironment(String environmentName) {
            this.rawJob.put("environment", environmentName);
        }

        private Predicate<? super Step> hasId(String id) {
            return step -> step.getId().equals(id);
        }

        public void replaceStep(String stepId, WorkflowStep step) {
            List<Map<String, Object>> allSteps = this.getRawSteps();
            int index = this.findStepIndex(stepId);
            LOG.fine(() -> "Replacing step '" + stepId + "' at index " + index + " with step '" + step.getId() + "'");
            allSteps.set(index, step.getRawStep());
        }

        public void insertStepAfter(String stepId, WorkflowStep step) {
            List<Map<String, Object>> allSteps = this.getRawSteps();
            int index = this.findStepIndex(stepId);
            LOG.fine(() -> "Inserting step '" + step.getId() + "' at index " + (index + 1) + " after step '" + stepId + "'");
            allSteps.add(index + 1, step.getRawStep());
        }

        private int findStepIndex(String stepId) {
            List<Step> steps = this.getSteps();
            return IntStream.range(0, steps.size()).filter(index -> ((Step)steps.get(index)).getId().equals(stepId)).findFirst().orElseThrow(() -> new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-205").message("No step found for id {{step id}} in {{raw job}}", stepId, this.rawJob).toString()));
        }
    }

    static class Step {
        private final Map<String, Object> rawStep;

        private Step(Map<String, Object> rawStep) {
            this.rawStep = rawStep;
        }

        String getId() {
            return this.getString("id");
        }

        String getName() {
            return this.getString("name");
        }

        String getRunCommand() {
            return this.getString("run");
        }

        String getIfCondition() {
            return this.getString("if");
        }

        String getUsesAction() {
            return this.getString("uses");
        }

        public Map<String, Object> getWith() {
            return GitHubWorkflow.asMap(this.rawStep.get("with"));
        }

        private String getString(String key) {
            return this.getOptionalString(key).orElseThrow(() -> new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-204").message("Step has no field {{field name}}: {{raw step}}", key, this.rawStep).toString()));
        }

        private Optional<String> getOptionalString(String key) {
            return Optional.ofNullable((String)this.rawStep.get(key));
        }
    }
}

