/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.projectkeeper.validators.files.ContentCustomizingTemplate;
import com.exasol.projectkeeper.validators.files.GitHubWorkflow;
import com.exasol.projectkeeper.validators.files.GitHubWorkflowIO;
import java.util.Arrays;
import java.util.List;

class GitHubWorkflowCustomizer
implements ContentCustomizingTemplate.ContentCustomizer {
    private static final String GENERATED_COMMENT = "# This file was generated by Project Keeper.\n";
    private final GitHubWorkflowIO yaml;
    private final List<WorkflowCustomizer> customizer;

    GitHubWorkflowCustomizer(WorkflowCustomizer ... customizer) {
        this(GitHubWorkflowIO.create(), Arrays.asList(customizer));
    }

    GitHubWorkflowCustomizer(GitHubWorkflowIO yaml, List<WorkflowCustomizer> customizer) {
        this.yaml = yaml;
        this.customizer = customizer;
    }

    @Override
    public String customizeContent(String content) {
        GitHubWorkflow workflow = this.yaml.loadWorkflow(content);
        this.customizeWorkflow(workflow);
        return GENERATED_COMMENT + this.yaml.dumpWorkflow(workflow);
    }

    private void customizeWorkflow(GitHubWorkflow workflow) {
        this.customizer.forEach(c -> c.applyCustomization(workflow));
    }

    static interface WorkflowCustomizer {
        public void applyCustomization(GitHubWorkflow var1);
    }
}

