/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.files.GitHubWorkflow;
import com.exasol.projectkeeper.validators.files.GitHubWorkflowCustomizer;

class GitHubWorkflowEnvironmentCustomizer
implements GitHubWorkflowCustomizer.WorkflowCustomizer {
    private final String environmentName;
    private final String jobId;

    GitHubWorkflowEnvironmentCustomizer(String jobId, String environmentName) {
        this.jobId = jobId;
        this.environmentName = environmentName;
    }

    @Override
    public void applyCustomization(GitHubWorkflow workflow) {
        if (this.environmentName == null) {
            return;
        }
        GitHubWorkflow.Job job = workflow.getJob(this.jobId);
        if (job == null) {
            throw new IllegalArgumentException(ExaError.messageBuilder("E-PK-CORE-207").message("GitHub Workflow does not have a job with ID {{job id}}", this.jobId).toString());
        }
        job.setEnvironment(this.environmentName);
    }
}

