/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.projectkeeper.validators.files.GitHubWorkflow;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.NonPrintableStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;

public class GitHubWorkflowIO {
    private final Load loader;
    private final Dump dumper;

    private GitHubWorkflowIO(Load loader, Dump dumper) {
        this.loader = loader;
        this.dumper = dumper;
    }

    public static GitHubWorkflowIO create() {
        LoadSettings loadSettings = LoadSettings.builder().setParseComments(true).build();
        DumpSettings dumpSettings = DumpSettings.builder().setBestLineBreak("\n").setCanonical(false).setDefaultFlowStyle(FlowStyle.AUTO).setDefaultScalarStyle(ScalarStyle.PLAIN).setDumpComments(true).setExplicitEnd(false).setExplicitStart(false).setIndent(2).setIndentWithIndicator(true).setIndicatorIndent(2).setWidth(200).setMultiLineFlow(true).setNonPrintableStyle(NonPrintableStyle.ESCAPE).setUseUnicodeEncoding(true).setSplitLines(false).build();
        return new GitHubWorkflowIO(new Load(loadSettings), new Dump(dumpSettings));
    }

    public GitHubWorkflow loadWorkflow(String content) {
        return GitHubWorkflow.create(this.load(content));
    }

    Object load(String content) {
        return this.loader.loadFromString(content);
    }

    public String dumpWorkflow(GitHubWorkflow workflow) {
        return this.dump(workflow.getRawObject());
    }

    String dump(Object object) {
        return this.dumper.dumpToString(object);
    }
}

