/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.projectkeeper.shared.config.workflow.StepCustomization;
import com.exasol.projectkeeper.validators.files.GitHubWorkflow;
import com.exasol.projectkeeper.validators.files.GitHubWorkflowCustomizer;
import java.util.List;

class GitHubWorkflowStepCustomizer
implements GitHubWorkflowCustomizer.WorkflowCustomizer {
    private final List<StepCustomization> customizations;
    private final String jobId;

    GitHubWorkflowStepCustomizer(List<StepCustomization> customizations, String jobId) {
        this.customizations = customizations;
        this.jobId = jobId;
    }

    @Override
    public void applyCustomization(GitHubWorkflow workflow) {
        GitHubWorkflow.Job job = workflow.getJob(this.jobId);
        for (StepCustomization customization : this.customizations) {
            this.applyCustomization(job, customization);
        }
    }

    private void applyCustomization(GitHubWorkflow.Job job, StepCustomization customization) {
        switch (customization.getType()) {
            case REPLACE: {
                job.replaceStep(customization.getStepId(), customization.getStep());
                break;
            }
            case INSERT_AFTER: {
                job.insertStepAfter(customization.getStepId(), customization.getStep());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown customization type: " + customization.getType());
            }
        }
    }
}

