/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Logger;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.shared.config.BuildOptions;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.validators.files.FileTemplate;
import com.exasol.projectkeeper.validators.files.FileTemplatesFactory;
import com.exasol.projectkeeper.validators.files.RequiredFileValidator;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ProjectFilesValidator
implements Validator {
    private final Path projectDirectory;
    private final List<AnalyzedSource> sources;
    private final Logger logger;
    private final String projectKeeperVersion;
    private final boolean hasNpmModule;
    private final BuildOptions buildConfig;

    private ProjectFilesValidator(Builder builder) {
        this.projectDirectory = Objects.requireNonNull(builder.projectDirectory, "projectDirectory");
        this.sources = Objects.requireNonNull(builder.sources, "sources");
        this.logger = Objects.requireNonNull(builder.logger, "logger");
        this.projectKeeperVersion = Objects.requireNonNull(builder.projectKeeperVersion, "projectKeeperVersion");
        this.hasNpmModule = builder.hasNpmModule;
        this.buildConfig = Objects.requireNonNull(builder.buildOptions, "buildConfig");
    }

    @Override
    public List<ValidationFinding> validate() {
        ArrayList<ValidationFinding> findings = new ArrayList<ValidationFinding>();
        FileTemplatesFactory templatesFactory = new FileTemplatesFactory(this.logger, this.projectKeeperVersion, this.hasNpmModule, this.buildConfig);
        findings.addAll(this.validateTemplatesRelativeToRepo(templatesFactory));
        findings.addAll(this.validateTemplatesRelativeToSource(templatesFactory));
        return findings;
    }

    private List<ValidationFinding> validateTemplatesRelativeToSource(FileTemplatesFactory templatesFactory) {
        ArrayList<ValidationFinding> findings = new ArrayList<ValidationFinding>();
        for (AnalyzedSource source : this.sources) {
            Path sourceDir = this.directoryOf(source.getPath());
            List<FileTemplate> templates = templatesFactory.getTemplatesForSource(source);
            findings.addAll(this.runValidation(templates, sourceDir));
        }
        return findings;
    }

    private List<ValidationFinding> validateTemplatesRelativeToRepo(FileTemplatesFactory templatesFactory) {
        List<FileTemplate> templates = templatesFactory.getGlobalTemplates(this.sources);
        return this.runValidation(templates, this.projectDirectory);
    }

    private List<ValidationFinding> runValidation(List<FileTemplate> templates, Path relativeDirectory) {
        ArrayList<ValidationFinding> findings = new ArrayList<ValidationFinding>();
        for (FileTemplate template : templates) {
            findings.addAll(this.validate(relativeDirectory, template));
        }
        return findings;
    }

    private Path directoryOf(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        return path.getParent();
    }

    private List<ValidationFinding> validate(Path projectDirectory, FileTemplate template) {
        Path projectFile = projectDirectory.resolve(template.getPathInProject());
        RequiredFileValidator.ContentValidator contentValidator = this.getContentValidator(template);
        return new RequiredFileValidator().validateFile(projectDirectory, projectFile, contentValidator);
    }

    private RequiredFileValidator.ContentValidator getContentValidator(FileTemplate template) {
        switch (template.getValidation()) {
            case REQUIRE_EXACT: {
                return RequiredFileValidator.withContentEqualTo(template.getContent());
            }
            case REQUIRE_EXIST: {
                return RequiredFileValidator.fileExists(template.getContent());
            }
        }
        throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-119").message("Unknown template type {{template type}}", new Object[]{template.getValidation()}).ticketMitigation().toString());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Path projectDirectory;
        private List<AnalyzedSource> sources;
        private Logger logger;
        private String projectKeeperVersion;
        private boolean hasNpmModule;
        private BuildOptions buildOptions;

        private Builder() {
        }

        public Builder projectDirectory(Path projectDirectory) {
            this.projectDirectory = projectDirectory;
            return this;
        }

        public Builder analyzedSources(List<AnalyzedSource> value) {
            this.sources = value;
            return this;
        }

        public Builder logger(Logger value) {
            this.logger = value;
            return this;
        }

        public Builder projectKeeperVersion(String value) {
            this.projectKeeperVersion = value;
            return this;
        }

        public Builder hasNpmModule(boolean value) {
            this.hasNpmModule = value;
            return this;
        }

        public Builder ciBuildOptions(BuildOptions buildOptions) {
            this.buildOptions = buildOptions;
            return this;
        }

        public ProjectFilesValidator build() {
            return new ProjectFilesValidator(this);
        }
    }
}

