/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class RequiredFileValidator {
    public static ContentValidator withContentEqualTo(String content) {
        return new EqualsContentValidator(content);
    }

    public static ContentValidator fileExists(String defaultContent) {
        return new FileExistsValidator(defaultContent);
    }

    private static void fixFile(Path file, String templateContent) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.writeString(file, (CharSequence)templateContent.replace("\r", "").replace("\n", System.lineSeparator()), new OpenOption[0]);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-16").message("Failed to create or replace {{required file}}.", new Object[0]).parameter("required file", file).toString(), exception);
        }
    }

    private static String unifyNewlines(String content) {
        if (content == null) {
            return null;
        }
        return content.replace("\r", "");
    }

    public List<ValidationFinding> validateFile(Path projectDir, Path file, ContentValidator contentValidator) {
        String content = this.getActualContent(projectDir, file);
        String contentWithUnifiedNewline = RequiredFileValidator.unifyNewlines(content);
        Optional<String> newContent = contentValidator.validateContent(contentWithUnifiedNewline);
        if (newContent.isPresent()) {
            SimpleValidationFinding.Fix fix = log -> RequiredFileValidator.fixFile(file, (String)newContent.get());
            if (contentWithUnifiedNewline == null) {
                return List.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder("E-PK-CORE-17").message("Missing required file: {{required file}}", new Object[0]).parameter("required file", this.osIndependentPath(projectDir, file)).toString()).andFix(fix).build());
            }
            return List.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder("E-PK-CORE-18").message("Outdated content: {{file name}}", this.osIndependentPath(projectDir, file)).toString()).andFix(fix).build());
        }
        return Collections.emptyList();
    }

    private String osIndependentPath(Path projectDir, Path file) {
        return projectDir.relativize(file).toString().replace(FileSystems.getDefault().getSeparator(), "/");
    }

    private String getActualContent(Path projectDir, Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.readString(file);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-19").message("Failed to validate {{file name}}'s content.", new Object[0]).parameter("file name", this.osIndependentPath(projectDir, file)).toString(), exception);
        }
    }

    private static class EqualsContentValidator
    implements ContentValidator {
        private final String expectedContent;

        private EqualsContentValidator(String expectedContent) {
            this.expectedContent = RequiredFileValidator.unifyNewlines(expectedContent);
        }

        @Override
        public Optional<String> validateContent(String content) {
            if (!this.expectedContent.equals(content)) {
                return Optional.of(this.expectedContent);
            }
            return Optional.empty();
        }
    }

    private static class FileExistsValidator
    implements ContentValidator {
        private final String defaultContent;

        private FileExistsValidator(String defaultContent) {
            this.defaultContent = defaultContent;
        }

        @Override
        public Optional<String> validateContent(String content) {
            if (content == null) {
                return Optional.of(this.defaultContent);
            }
            return Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface ContentValidator {
        public Optional<String> validateContent(String var1);
    }
}

