/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.finding;

import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFindingGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FindingFilter {
    private final List<Pattern> denyListPatterns;

    public FindingFilter(List<String> denyList) {
        this.denyListPatterns = denyList.stream().map(pattern -> Pattern.compile(pattern, 32)).collect(Collectors.toList());
    }

    public List<ValidationFinding> filterFindings(List<ValidationFinding> findings) {
        ArrayList<ValidationFinding> result = new ArrayList<ValidationFinding>();
        for (ValidationFinding finding : findings) {
            FilteringVisitor visitor = new FilteringVisitor(this.denyListPatterns);
            finding.accept(visitor);
            visitor.getResult().ifPresent(result::add);
        }
        return result;
    }

    private static class FilteringVisitor
    implements ValidationFinding.Visitor {
        private final List<Pattern> denyList;
        private Optional<ValidationFinding> result;

        FilteringVisitor(List<Pattern> denyList) {
            this.denyList = denyList;
        }

        @Override
        public void visit(SimpleValidationFinding finding) {
            this.result = !this.isExcluded(finding) ? Optional.of(finding) : Optional.empty();
        }

        private boolean isExcluded(SimpleValidationFinding finding) {
            for (Pattern denyListPattern : this.denyList) {
                if (!denyListPattern.matcher(finding.getMessage()).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visit(ValidationFindingGroup finding) {
            List<ValidationFinding> nestedFindings = finding.getFindings();
            ArrayList<ValidationFinding> filteredNestedFindings = new ArrayList<ValidationFinding>(nestedFindings.size());
            for (ValidationFinding eachFinding : nestedFindings) {
                FilteringVisitor visitor = new FilteringVisitor(this.denyList);
                eachFinding.accept(visitor);
                visitor.getResult().ifPresent(filteredNestedFindings::add);
            }
            this.result = filteredNestedFindings.isEmpty() ? Optional.empty() : Optional.of(new ValidationFindingGroup(filteredNestedFindings, finding.getPostFix()));
        }

        public Optional<ValidationFinding> getResult() {
            return this.result;
        }
    }
}

