/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom;

import com.exasol.projectkeeper.RepoInfo;
import com.exasol.projectkeeper.shared.config.ParentPomRef;
import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.validators.pom.builder.DocumentBuilder;
import com.exasol.projectkeeper.validators.pom.builder.ElementBuilder;
import com.exasol.projectkeeper.validators.pom.builder.NodeBuilder;
import com.exasol.projectkeeper.validators.pom.io.PomFileReader;
import com.exasol.projectkeeper.validators.pom.io.PomFileWriter;
import com.exasol.projectkeeper.validators.pom.plugin.ErrorCodeCrawlerPluginTemplateGenerator;
import com.exasol.projectkeeper.validators.pom.plugin.FailsafePluginTemplateGenerator;
import com.exasol.projectkeeper.validators.pom.plugin.JacocoPluginTemplateGenerator;
import com.exasol.projectkeeper.validators.pom.plugin.PluginTemplateGenerator;
import com.exasol.projectkeeper.validators.pom.plugin.SimplePluginTemplateGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Node;

public class PomFileGenerator {
    public static final String DEFAULT_JAVA_VERSION = "11";
    private static final List<PluginTemplateGenerator> PLUGIN_GENERATORS = List.of(new SimplePluginTemplateGenerator("maven_templates/sonar-maven-plugin.xml", ProjectKeeperModule.DEFAULT), new SimplePluginTemplateGenerator("maven_templates/maven-toolchains-plugin.xml", ProjectKeeperModule.DEFAULT), new SimplePluginTemplateGenerator("maven_templates/maven-compiler-plugin.xml", ProjectKeeperModule.DEFAULT), new SimplePluginTemplateGenerator("maven_templates/maven-enforcer-plugin.xml", ProjectKeeperModule.DEFAULT), new SimplePluginTemplateGenerator("maven_templates/flatten-maven-plugin.xml", ProjectKeeperModule.DEFAULT), new SimplePluginTemplateGenerator("maven_templates/ossindex-maven-plugin.xml", ProjectKeeperModule.DEFAULT), new SimplePluginTemplateGenerator("maven_templates/maven-surefire-plugin.xml", ProjectKeeperModule.DEFAULT), new SimplePluginTemplateGenerator("maven_templates/versions-maven-plugin.xml", ProjectKeeperModule.DEFAULT), new SimplePluginTemplateGenerator("maven_templates/duplicate-finder-maven-plugin.xml", ProjectKeeperModule.DEFAULT), new SimplePluginTemplateGenerator("maven_templates/maven-assembly-plugin.xml", ProjectKeeperModule.JAR_ARTIFACT), new SimplePluginTemplateGenerator("maven_templates/maven-jar-plugin-exclusion.xml", ProjectKeeperModule.JAR_ARTIFACT), new SimplePluginTemplateGenerator("maven_templates/artifact-reference-checker-maven-plugin.xml", ProjectKeeperModule.JAR_ARTIFACT), new SimplePluginTemplateGenerator("maven_templates/maven-deploy-plugin.xml", ProjectKeeperModule.MAVEN_CENTRAL), new SimplePluginTemplateGenerator("maven_templates/maven-gpg-plugin.xml", ProjectKeeperModule.MAVEN_CENTRAL), new SimplePluginTemplateGenerator("maven_templates/maven-source-plugin.xml", ProjectKeeperModule.MAVEN_CENTRAL), new SimplePluginTemplateGenerator("maven_templates/maven-javadoc-plugin.xml", ProjectKeeperModule.MAVEN_CENTRAL), new SimplePluginTemplateGenerator("maven_templates/nexus-staging-maven-plugin.xml", ProjectKeeperModule.MAVEN_CENTRAL), new SimplePluginTemplateGenerator("maven_templates/maven-dependency-plugin.xml", ProjectKeeperModule.UDF_COVERAGE), new SimplePluginTemplateGenerator("maven_templates/native-image-maven-plugin.xml", ProjectKeeperModule.NATIVE_IMAGE), new SimplePluginTemplateGenerator("maven_templates/lombok-maven-plugin.xml", ProjectKeeperModule.LOMBOK), new FailsafePluginTemplateGenerator(), new JacocoPluginTemplateGenerator(), new ErrorCodeCrawlerPluginTemplateGenerator(), new SimplePluginTemplateGenerator("maven_templates/reproducible-build-maven-plugin.xml", ProjectKeeperModule.DEFAULT));
    private static final String VERSION = "version";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String GROUP_ID = "groupId";

    public String generatePomContent(Collection<ProjectKeeperModule> enabledModules, String groupId, String artifactId, String version, ParentPomRef parentPomRef, RepoInfo repoInfo) {
        return this.generatePomContent(new Config(enabledModules, groupId, artifactId, version, parentPomRef, repoInfo));
    }

    private String generatePomContent(Config config) {
        DocumentBuilder builder = (DocumentBuilder)((DocumentBuilder)((DocumentBuilder)NodeBuilder.document().child(NodeBuilder.comment("@formatter:off"))).child(NodeBuilder.comment("This file is auto-generated by project-keeper. All changes will be overwritten."))).child(this.projectBuilder(config));
        return PomFileWriter.writeString(builder.build());
    }

    private NodeBuilder projectBuilder(Config config) {
        ParentPomRef parentPomRef = config.getParentPomRef();
        Collection<ProjectKeeperModule> modules = config.getEnabledModules();
        return (NodeBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)NodeBuilder.element("http://maven.apache.org/POM/4.0.0", "project").attribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd").child("modelVersion", "4.0.0")).child(GROUP_ID, config.getGroupId())).child(ARTIFACT_ID, config.getArtifactId())).child(VERSION, config.getVersion())).child("packaging", "pom")).nullableChild(this.parentReference(parentPomRef))).child(this.properties(modules))).nullableChild(this.profiles(modules))).nullableChild(this.distributionManagement(modules))).child(this.licenses(config))).child(this.developers())).child(this.scm(config.getRepoInfo().getRepoName()))).child(this.dependencies(modules))).child(this.build(modules));
    }

    private ElementBuilder profiles(Collection<ProjectKeeperModule> modules) {
        if (!modules.contains((Object)ProjectKeeperModule.NATIVE_IMAGE)) {
            return null;
        }
        return (ElementBuilder)((ElementBuilder)NodeBuilder.element("profiles").child(this.profile("default", true, Map.of("native-image.skip", "false")))).child(this.profile("skipNativeImage", false, Map.of("native-image.skip", "true", "test.excludeTags", "native-image")));
    }

    private ElementBuilder profile(String id, boolean isDefault, Map<String, String> properties) {
        List<NodeBuilder> propertyBuilders = properties.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (ElementBuilder)NodeBuilder.element((String)e.getKey()).child(NodeBuilder.textNode((String)e.getValue()))).collect(Collectors.toList());
        return (ElementBuilder)((ElementBuilder)((ElementBuilder)NodeBuilder.element("profile").child("id", id)).nullableChild(isDefault ? (NodeBuilder)NodeBuilder.element("activation").child("activeByDefault", "true") : null)).child((NodeBuilder)NodeBuilder.element("properties").children(propertyBuilders));
    }

    private ElementBuilder distributionManagement(Collection<ProjectKeeperModule> modules) {
        if (!modules.contains((Object)ProjectKeeperModule.MAVEN_CENTRAL)) {
            return null;
        }
        return (ElementBuilder)((ElementBuilder)NodeBuilder.element("distributionManagement").child((NodeBuilder)((ElementBuilder)NodeBuilder.element("snapshotRepository").child("id", "ossrh")).child("url", "https://oss.sonatype.org/content/repositories/snapshots"))).child((NodeBuilder)((ElementBuilder)NodeBuilder.element("repository").child("id", "ossrh")).child("url", "https://oss.sonatype.org/service/local/staging/deploy/maven2/"));
    }

    private ElementBuilder licenses(Config config) {
        String url = "https://github.com/exasol/" + config.getRepoInfo().getRepoName() + "/blob/main/LICENSE";
        return (ElementBuilder)NodeBuilder.element("licenses").child((NodeBuilder)((ElementBuilder)((ElementBuilder)NodeBuilder.element("license").child("name", config.getRepoInfo().getLicenseName())).child("url", url)).child("distribution", "repo"));
    }

    private ElementBuilder scm(String repoName) {
        String gitUrl = "scm:git:https://github.com/exasol/" + repoName + ".git";
        return (ElementBuilder)((ElementBuilder)((ElementBuilder)NodeBuilder.element("scm").child("connection", gitUrl)).child("developerConnection", gitUrl)).child("url", "https://github.com/exasol/" + repoName + "/");
    }

    private ElementBuilder developers() {
        return (ElementBuilder)NodeBuilder.element("developers").child((NodeBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)NodeBuilder.element("developer").child("name", "Exasol")).child("email", "opensource@exasol.com")).child("organization", "Exasol AG")).child("organizationUrl", "https://www.exasol.com/"));
    }

    private ElementBuilder parentReference(ParentPomRef parentPomRef) {
        if (parentPomRef == null) {
            return null;
        }
        String path = parentPomRef.getRelativePath();
        return (ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)NodeBuilder.element("parent").child(GROUP_ID, parentPomRef.getGroupId())).child(ARTIFACT_ID, parentPomRef.getArtifactId())).child(VERSION, parentPomRef.getVersion())).nullableChild(path == null ? null : NodeBuilder.element("relativePath").text(path));
    }

    private ElementBuilder dependencies(Collection<ProjectKeeperModule> enabledModules) {
        return (ElementBuilder)((ElementBuilder)NodeBuilder.element("dependencies").nullableChild(enabledModules.contains((Object)ProjectKeeperModule.LOMBOK) ? this.dependency("org.projectlombok", "lombok", "1.18.32", "provided", null) : null)).nullableChild(enabledModules.contains((Object)ProjectKeeperModule.UDF_COVERAGE) ? this.dependency("org.jacoco", "org.jacoco.agent", "0.8.12", "test", "runtime") : null);
    }

    private ElementBuilder dependency(String groupId, String artifactId, String version, String scope, String classifier) {
        return (ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)NodeBuilder.element("dependency").child(GROUP_ID, groupId)).child(ARTIFACT_ID, artifactId)).child(VERSION, version)).child("scope", scope)).nullableChild(classifier == null ? null : NodeBuilder.element("classifier").text(classifier));
    }

    private ElementBuilder build(Collection<ProjectKeeperModule> enabledModules) {
        return (ElementBuilder)NodeBuilder.element("build").child(this.plugins(enabledModules));
    }

    private ElementBuilder properties(Collection<ProjectKeeperModule> enabledModules) {
        return (ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)((ElementBuilder)NodeBuilder.element("properties").child("project.build.sourceEncoding", "UTF-8")).child("project.reporting.outputEncoding", "UTF-8")).child("java.version", DEFAULT_JAVA_VERSION)).child("sonar.organization", "exasol")).child("sonar.host.url", "https://sonarcloud.io")).child("test.excludeTags", "")).nullableChild(!enabledModules.contains((Object)ProjectKeeperModule.MAVEN_CENTRAL) ? null : NodeBuilder.element("gpg.skip").text("true"));
    }

    private ElementBuilder plugins(Collection<ProjectKeeperModule> enabledModules) {
        ElementBuilder builder = NodeBuilder.element("plugins");
        for (PluginTemplateGenerator pluginGenerator : PLUGIN_GENERATORS) {
            Optional<Node> pluginTemplate = pluginGenerator.generateTemplate(enabledModules);
            pluginTemplate.ifPresent(template -> {
                PomFileReader.trimWhitespace(template);
                builder.child(NodeBuilder.plainNode(template));
            });
        }
        return builder;
    }

    private static class Config {
        private final Collection<ProjectKeeperModule> enabledModules;
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final ParentPomRef parentPomRef;
        private final RepoInfo repoInfo;

        private Config(Collection<ProjectKeeperModule> enabledModules, String groupId, String artifactId, String version, ParentPomRef parentPomRef, RepoInfo repoInfo) {
            this.enabledModules = enabledModules;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.parentPomRef = parentPomRef;
            this.repoInfo = repoInfo;
        }

        private Collection<ProjectKeeperModule> getEnabledModules() {
            return this.enabledModules;
        }

        private String getGroupId() {
            return this.groupId;
        }

        private String getArtifactId() {
            return this.artifactId;
        }

        private String getVersion() {
            return this.version;
        }

        private ParentPomRef getParentPomRef() {
            return this.parentPomRef;
        }

        private RepoInfo getRepoInfo() {
            return this.repoInfo;
        }
    }
}

