/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom;

import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PomFileIO {
    private static final MavenXpp3Writer WRITER = new MavenXpp3Writer();
    private static final MavenXpp3Reader READER = new MavenXpp3Reader();

    public Model readPom(Path path) {
        try {
            return READER.read(Files.newBufferedReader(path));
        }
        catch (IOException | XmlPullParserException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-172").message("Failed to read pom {{pom file path}}", path).toString(), exception);
        }
    }

    public void writePom(Model model, Path path) {
        try {
            WRITER.write(Files.newOutputStream(path, new OpenOption[0]), model);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder("E-PK-CORE-173").message("Failed to write pom {{pom file path}}", path).toString(), exception);
        }
    }
}

