/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom.builder;

import com.exasol.projectkeeper.validators.pom.builder.ChildrenBuilder;
import com.exasol.projectkeeper.validators.pom.builder.NodeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementBuilder
extends ChildrenBuilder<ElementBuilder>
implements NodeBuilder {
    private final String namespace;
    private final String name;
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    ElementBuilder(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public ElementBuilder text(String text) {
        return (ElementBuilder)this.child(NodeBuilder.textNode(text));
    }

    public ElementBuilder attribute(String name, String value) {
        return this.attribute(null, name, value);
    }

    public ElementBuilder attribute(String namespace, String name, String value) {
        this.attributes.add(new Attribute(namespace, name, value));
        return this;
    }

    @Override
    public Node build(Document document) {
        Element element = this.namespace == null ? document.createElement(this.name) : document.createElementNS(this.namespace, this.name);
        for (Attribute attr : this.attributes) {
            if (attr.namespace == null) {
                element.setAttribute(attr.name, attr.value);
                continue;
            }
            element.setAttributeNS(attr.namespace, attr.name, attr.value);
        }
        this.children.stream().map(c -> c.build(document)).forEach(element::appendChild);
        return element;
    }

    @Override
    protected ElementBuilder getThis() {
        return this;
    }

    static class Attribute {
        final String namespace;
        final String name;
        final String value;

        Attribute(String namespace, String name, String value) {
            this.namespace = namespace;
            this.name = name;
            this.value = value;
        }
    }
}

