/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom.io;

import com.exasol.errorreporting.ExaError;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PomFileReader {
    private final DocumentBuilder documentBuilder;

    public static Document parse(Path file) {
        return PomFileReader.instance().parseFile(file);
    }

    public static Document parse(String content) {
        return PomFileReader.instance().parseString(content);
    }

    static PomFileReader instance() {
        return new PomFileReader(PomFileReader.documentBuilder());
    }

    static DocumentBuilder documentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            return factory.newDocumentBuilder();
        }
        catch (IllegalArgumentException | ParserConfigurationException exception) {
            throw new IllegalStateException(exception);
        }
    }

    private PomFileReader(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    public static void trimWhitespace(Node node) {
        NodeList children = node.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node child = children.item(index);
            if (child.getNodeType() == 3) {
                child.setTextContent(child.getTextContent().trim());
            }
            PomFileReader.trimWhitespace(child);
        }
    }

    Document parseFile(Path pomFile) {
        Document document;
        FileInputStream pomFileStream = new FileInputStream(pomFile.toFile());
        try {
            Document document2 = this.documentBuilder.parse(pomFileStream);
            PomFileReader.trimWhitespace(document2);
            document = document2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)pomFileStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SAXException exception) {
                throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-107").message("Failed to read pom file {{path}}.", pomFile).toString(), exception);
            }
        }
        ((InputStream)pomFileStream).close();
        return document;
    }

    private Document parseString(String pomFileContent) {
        Document document;
        ByteArrayInputStream pomFileStream = new ByteArrayInputStream(pomFileContent.getBytes(StandardCharsets.UTF_8));
        try {
            document = this.documentBuilder.parse(pomFileStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)pomFileStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SAXException exception) {
                throw new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-108").message("Failed to read pom from string {{string}}.", pomFileContent).toString(), exception);
            }
        }
        ((InputStream)pomFileStream).close();
        return document;
    }
}

