/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom.io;

import com.exasol.errorreporting.ExaError;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class PomFileWriter {
    private final Transformer transformer;

    public static void writeFile(Document document, Path destinationFile) {
        PomFileWriter.instance().writeToFile(document, destinationFile);
    }

    public static String writeString(Document document) {
        return PomFileWriter.instance().writeToString(document);
    }

    private static PomFileWriter instance() {
        return new PomFileWriter(PomFileWriter.createTransformer());
    }

    static Transformer createTransformer() throws IllegalStateException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            return transformer;
        }
        catch (TransformerConfigurationException exception) {
            throw new IllegalStateException(exception);
        }
    }

    PomFileWriter(Transformer transformer) {
        this.transformer = transformer;
    }

    void writeToFile(Document document, Path destinationFile) {
        try (FileOutputStream stream = new FileOutputStream(destinationFile.toFile());){
            this.write(document, stream);
        }
        catch (IOException | TransformerException exception) {
            throw new IllegalStateException(ExaError.messageBuilder("F-PK-CORE-100").message("Failed to write POM XML to file {{file}}.", destinationFile).toString(), exception);
        }
    }

    String writeToString(Document document) {
        String string;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.write(document, stream);
            string = stream.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException exception) {
                throw new IllegalStateException(ExaError.messageBuilder("F-PK-CORE-106").message("Failed to convert POM XML document to string.", new Object[0]).toString(), exception);
            }
        }
        stream.close();
        return string;
    }

    private void write(Document document, OutputStream stream) throws TransformerException {
        this.transformer.transform(new DOMSource(document), new StreamResult(stream));
    }
}

