/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom.plugin;

import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.validators.pom.plugin.PluginTemplateGenerator;
import com.exasol.projectkeeper.validators.pom.plugin.PluginTemplateReader;
import com.exasol.projectkeeper.xpath.XPathErrorHandlingWrapper;
import java.util.Collection;
import java.util.Optional;
import org.w3c.dom.Node;

public class FailsafePluginTemplateGenerator
implements PluginTemplateGenerator {
    private static final String TEST_COVERAGE_CONFIGURATION = "configuration/systemPropertyVariables/test.coverage";
    private static final String TEMPLATE = "maven_templates/maven-failsafe-plugin.xml";

    @Override
    public Optional<Node> generateTemplate(Collection<ProjectKeeperModule> enabledModules) {
        if (enabledModules.contains((Object)ProjectKeeperModule.INTEGRATION_TESTS)) {
            Node pluginTemplate = new PluginTemplateReader().readPluginTemplate(TEMPLATE);
            if (!enabledModules.contains((Object)ProjectKeeperModule.UDF_COVERAGE)) {
                this.removeCoverageConfig(pluginTemplate);
            }
            return Optional.of(pluginTemplate);
        }
        return Optional.empty();
    }

    private void removeCoverageConfig(Node pluginTemplate) {
        Node coverageConfig = XPathErrorHandlingWrapper.runXPath(pluginTemplate, TEST_COVERAGE_CONFIGURATION);
        coverageConfig.getParentNode().removeChild(coverageConfig);
    }
}

