/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.pom.plugin;

import com.exasol.errorreporting.ExaError;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PluginTemplateReader {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = PluginTemplateReader.createXmlDocumentBuilderFactory();

    private static DocumentBuilderFactory createXmlDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return factory;
    }

    public Node readPluginTemplate(String templateResourceName) {
        Node node;
        block8: {
            InputStream templateInputStream = this.readResource(templateResourceName);
            try {
                DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
                node = documentBuilder.parse(templateInputStream).getFirstChild();
                if (templateInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (templateInputStream != null) {
                        try {
                            templateInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParserConfigurationException | SAXException exception) {
                    throw new IllegalStateException(ExaError.messageBuilder("F-PK-CORE-10").message("Failed to parse plugin template {{template}}.", templateResourceName).ticketMitigation().toString(), exception);
                }
            }
            templateInputStream.close();
        }
        return node;
    }

    private InputStream readResource(String templateResourceName) {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(templateResourceName);
        if (stream == null) {
            throw new IllegalStateException(ExaError.messageBuilder("F-PK-CORE-11").message("Failed to open plugins template {{template}}.", templateResourceName).ticketMitigation().toString());
        }
        return stream;
    }
}

