/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.release;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import com.exasol.projectkeeper.validators.changesfile.FixedIssue;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import com.exasol.projectkeeper.validators.release.github.GitHubAdapter;
import com.exasol.projectkeeper.validators.release.github.IssueState;
import java.nio.file.Path;
import java.time.Clock;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ChangesFileReleaseValidator
implements Validator {
    private static final ZoneId UTC_ZONE = ZoneId.of("UTC");
    private final ChangesFile changesFile;
    private final Path changesFilePath;
    private final Clock clock;
    private final GitHubAdapter gitHubAdapter;

    ChangesFileReleaseValidator(String repoName, Path changesFilePath, ChangesFile changesFile) {
        this(changesFilePath, changesFile, GitHubAdapter.connect(repoName), Clock.systemUTC());
    }

    ChangesFileReleaseValidator(Path changesFilePath, ChangesFile changesFile, GitHubAdapter gitHubAdapter, Clock clock) {
        this.changesFilePath = changesFilePath;
        this.changesFile = changesFile;
        this.gitHubAdapter = gitHubAdapter;
        this.clock = clock;
    }

    @Override
    public List<ValidationFinding> validate() {
        return Stream.of(this.validateReleaseDate(), this.validateIssuesClosed(), this.validateSummary(), this.validateCodeName()).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private Optional<ValidationFinding> validateSummary() {
        Optional<ChangesFileSection> summarySection = this.changesFile.getSummarySection();
        if (summarySection.isEmpty()) {
            return this.noFindings();
        }
        if (this.hasEmptyContent(summarySection)) {
            return this.finding(ExaError.messageBuilder("E-PK-CORE-194").message("Section '## Summary' is empty in {{path}}.", this.changesFilePath).mitigation("Add content to section.", new Object[0]).toString());
        }
        return this.noFindings();
    }

    private boolean hasEmptyContent(Optional<ChangesFileSection> summarySection) {
        return summarySection.orElseThrow().getContent().stream().filter(Predicate.not(String::isBlank)).findAny().isEmpty();
    }

    private Optional<ValidationFinding> validateCodeName() {
        if (this.changesFile.getCodeName() == null || this.changesFile.getCodeName().isBlank()) {
            return this.finding(ExaError.messageBuilder("E-PK-CORE-197").message("Code name in {{path}} is missing.", this.changesFilePath).mitigation("Add a code name.", new Object[0]).toString());
        }
        return this.noFindings();
    }

    private Optional<ValidationFinding> validateReleaseDate() {
        Optional<LocalDate> releaseDate = this.changesFile.getParsedReleaseDate();
        if (releaseDate.isEmpty()) {
            return this.finding(ExaError.messageBuilder("E-PK-CORE-182").message("Release date {{release date}} has invalid format in {{changes file path}}", this.changesFile.getReleaseDate(), this.changesFilePath).toString());
        }
        LocalDate today = this.today();
        if (!releaseDate.get().equals(today)) {
            return this.finding(ExaError.messageBuilder("E-PK-CORE-183").message("Release date {{actual date}} must be today {{today}} in {{changes file path}}", releaseDate.get(), today, this.changesFilePath).toString());
        }
        return this.noFindings();
    }

    private Optional<ValidationFinding> validateIssuesClosed() {
        List<Integer> wrongIssues = this.getIssuesWronglyMarkedAsClosed();
        if (!wrongIssues.isEmpty()) {
            return this.finding(ExaError.messageBuilder("E-PK-CORE-186").message("The following GitHub issues are marked as fixed in {{changes file}} but are not closed in GitHub: {{issue numbers}}", this.changesFilePath, wrongIssues).toString());
        }
        return this.noFindings();
    }

    private List<Integer> getIssuesWronglyMarkedAsClosed() {
        Set mentionedTickets = this.changesFile.getFixedIssues().stream().map(FixedIssue::issueNumber).collect(Collectors.toSet());
        HashSet<Integer> stillOpenIssues = new HashSet<Integer>();
        for (Integer issue : mentionedTickets) {
            IssueState state = this.gitHubAdapter.getIssueState(issue);
            if (state == IssueState.CLOSED) continue;
            stillOpenIssues.add(issue);
        }
        return this.sort(stillOpenIssues);
    }

    private List<Integer> sort(Set<Integer> numbers) {
        ArrayList<Integer> list = new ArrayList<Integer>(numbers);
        list.sort(Comparator.naturalOrder());
        return list;
    }

    private LocalDate today() {
        return LocalDate.ofInstant(this.clock.instant(), UTC_ZONE);
    }

    private Optional<ValidationFinding> noFindings() {
        return Optional.empty();
    }

    private Optional<ValidationFinding> finding(String message) {
        return Optional.of(SimpleValidationFinding.withMessage(message).build());
    }
}

