/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.release;

import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileIO;
import com.exasol.projectkeeper.validators.release.ChangesFileReleaseValidator;
import java.nio.file.Path;
import java.util.List;

public class ReleaseInspector {
    private final String projectVersion;
    private final Path projectDirectory;
    private final ChangesFileIO changesFileIO;
    private final String repoName;

    public ReleaseInspector(String repoName, String projectVersion, Path projectDirectory) {
        this(repoName, projectVersion, projectDirectory, new ChangesFileIO());
    }

    ReleaseInspector(String repoName, String projectVersion, Path projectDirectory, ChangesFileIO changesFileIO) {
        this.repoName = repoName;
        this.projectVersion = projectVersion;
        this.projectDirectory = projectDirectory;
        this.changesFileIO = changesFileIO;
    }

    public List<Validator> validators() {
        Path changesFilePath = this.projectDirectory.resolve(ChangesFile.getPathForVersion(this.projectVersion));
        ChangesFile changesFile = this.changesFileIO.read(changesFilePath);
        return List.of(new ChangesFileReleaseValidator(this.repoName, changesFilePath, changesFile));
    }
}

