/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.release.github;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.release.github.GitHubConnectionProvider;
import com.exasol.projectkeeper.validators.release.github.IssueState;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Issue;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.logging.Logger;

public class GitHubAdapter {
    private static final Logger LOG = Logger.getLogger(GitHubAdapter.class.getName());
    private final GitHubConnectionProvider gitHubConnectionProvider;
    private final String repoName;
    private final String owner;

    GitHubAdapter(GitHubConnectionProvider gitHubConnectionProvider, String owner, String repoName) {
        this.gitHubConnectionProvider = gitHubConnectionProvider;
        this.owner = owner;
        this.repoName = repoName;
    }

    public static GitHubAdapter connect(String repoName) {
        return new GitHubAdapter(new GitHubConnectionProvider(), "exasol", repoName);
    }

    public IssueState getIssueState(int issueNumber) {
        Issue issue = this.gitHubConnectionProvider.connect().repos().get(new Coordinates.Simple(this.owner, this.repoName)).issues().get(issueNumber);
        Issue.Smart smartIssue = new Issue.Smart(issue);
        IssueState state = this.getIssueState(issueNumber, smartIssue);
        LOG.fine(() -> "GitHub issue #" + issueNumber + " has state " + state);
        return state;
    }

    private IssueState getIssueState(int issueNumber, Issue.Smart smartIssue) {
        try {
            if (!smartIssue.exists()) {
                return IssueState.MISSING;
            }
            if (smartIssue.isOpen()) {
                return IssueState.OPEN;
            }
            return IssueState.CLOSED;
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder("E-PK-CORE-192").message("Failed to get status of GitHub issue #{{issue number}}: {{cause}}", issueNumber, exception.getMessage()).toString(), exception);
        }
    }
}

