/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.release.github;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.sources.analyze.generic.SimpleProcess;
import com.jcabi.github.Github;
import com.jcabi.github.RtGithub;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

class GitHubConnectionProvider {
    private static final Logger LOG = Logger.getLogger(GitHubConnectionProvider.class.getName());
    private final Map<String, String> environmentVariables;

    GitHubConnectionProvider() {
        this(System.getenv());
    }

    GitHubConnectionProvider(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    Github connect() {
        return this.getToken().map(this::connectWithToken).orElseThrow(() -> new IllegalStateException(ExaError.messageBuilder("E-PK-CORE-185").message("Failed to get GitHub credentials.", new Object[0]).mitigation("Set environment variable GH_TOKEN or GITHUB_TOKEN", new Object[0]).mitigation("Configure 'gh' command line tool using 'gh auth login'", new Object[0]).toString()));
    }

    private Github connectWithToken(String token) {
        return new RtGithub(token);
    }

    Optional<String> getToken() {
        return this.getEnv("GH_TOKEN").or(() -> this.getEnv("GITHUB_TOKEN")).or(this::getTokenFromGhTool);
    }

    private Optional<String> getEnv(String name) {
        return Optional.ofNullable(this.environmentVariables.get(name));
    }

    private Optional<String> getTokenFromGhTool() {
        try {
            SimpleProcess process = SimpleProcess.start(List.of("gh", "auth", "token"));
            process.waitUntilFinished(Duration.ofSeconds(1L));
            return Optional.of(process.getOutputStreamContent().trim());
        }
        catch (RuntimeException exception) {
            LOG.log(Level.WARNING, exception, () -> "Failed to get GitHub token from 'gh' command line: " + exception.getMessage());
            return Optional.empty();
        }
    }
}

