/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.ScheduleWithFixedDelay;
import com.jcabi.log.Logger;
import com.jcabi.log.VerboseRunnable;
import com.jcabi.log.VerboseThreads;
import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public final class MethodScheduler {
    private final transient ConcurrentMap<Object, Service> services = new ConcurrentHashMap<Object, Service>(0);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ MethodScheduler ajc$perSingletonInstance;

    @After(value="initialization((@com.jcabi.aspects.ScheduleWithFixedDelay *).new(..))")
    public void instantiate(JoinPoint point) {
        VerboseRunnable runnable;
        Object object = point.getTarget();
        if (this.services.containsKey(object)) {
            throw new IllegalStateException(Logger.format("%[type]s was already scheduled for execution", object));
        }
        if (object instanceof Runnable) {
            runnable = new VerboseRunnable((Runnable)object, true);
        } else if (object instanceof Callable) {
            runnable = new VerboseRunnable((Callable)object, true);
        } else {
            throw new IllegalStateException(Logger.format("%[type]s doesn't implement Runnable or Callable", object));
        }
        this.services.put(object, new Service(runnable, object, object.getClass().getAnnotation(ScheduleWithFixedDelay.class)));
    }

    @Before(value="execution(* (@com.jcabi.aspects.ScheduleWithFixedDelay *).close())")
    public void close(JoinPoint point) {
        Object object = point.getTarget();
        ((Service)this.services.get(object)).close();
        this.services.remove(object);
    }

    public static MethodScheduler aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.MethodScheduler", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            MethodScheduler.ajc$perSingletonInstance = new MethodScheduler();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private static final class Service
    implements Closeable {
        private final transient ScheduledExecutorService executor;
        private final transient Object object;
        private final transient AtomicLong counter;
        private final transient long start = System.currentTimeMillis();
        private final transient long await;
        private final transient long attempts;
        private final transient boolean verbose;

        protected Service(Runnable runnable, Object obj, ScheduleWithFixedDelay annt) {
            this.counter = new AtomicLong();
            this.object = obj;
            this.executor = Executors.newScheduledThreadPool(annt.threads(), new VerboseThreads(this.object));
            this.verbose = annt.verbose();
            this.await = annt.awaitUnit().toMillis(annt.await());
            this.attempts = annt.shutdownAttempts();
            Runnable job = () -> {
                runnable.run();
                this.counter.incrementAndGet();
            };
            int thread = 0;
            while (thread < annt.threads()) {
                this.executor.scheduleWithFixedDelay(job, annt.delay(), annt.delay(), annt.unit());
                ++thread;
            }
            if (this.verbose) {
                Logger.info(this.object, "scheduled for execution with %d %s interval", new Object[]{annt.delay(), annt.unit()});
            }
        }

        @Override
        public void close() {
            this.executor.shutdown();
            long begin = System.currentTimeMillis();
            try {
                long age;
                while (!this.executor.awaitTermination(1L, TimeUnit.SECONDS) && (age = System.currentTimeMillis() - begin) <= this.await) {
                    if (!this.verbose) continue;
                    Logger.info(this, "waiting %[ms]s for threads termination", age);
                }
                int attempt = 0;
                while ((long)attempt < this.attempts) {
                    this.executor.shutdownNow();
                    this.executor.awaitTermination(1L, TimeUnit.SECONDS);
                    ++attempt;
                }
                if (!this.executor.isTerminated()) {
                    throw new IllegalStateException(Logger.format("failed to shutdown %[type]s of %[type]s", this.executor, this.object));
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
            if (this.verbose) {
                Logger.info(this.object, "execution stopped after %[ms]s and %d tick(s)", System.currentTimeMillis() - this.start, this.counter.get());
            }
        }
    }
}

