/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import org.apache.commons.lang3.builder.CompareToBuilder;

@Immutable
public interface Coordinates
extends Comparable<Coordinates> {
    public static final String SEPARATOR = "/";

    public String user();

    public String repo();

    @Immutable
    public static final class Https
    implements Coordinates {
        private static final String DOMAIN = "https://github.com/";
        private final String url;

        public Https(String https) {
            this.url = https;
        }

        @Override
        public String user() {
            return this.split()[0];
        }

        @Override
        public String repo() {
            String repo = this.split()[1];
            String suffix = ".git";
            if (repo.endsWith(".git")) {
                return repo.substring(0, repo.length() - ".git".length());
            }
            return repo;
        }

        @Override
        public int compareTo(Coordinates other) {
            return new CompareToBuilder().append(this.user(), other.user()).append(this.repo(), other.repo()).build();
        }

        private String[] split() {
            if (!this.url.startsWith(DOMAIN)) {
                throw new IllegalArgumentException(String.format("Invalid URL, the '%s' should start with '%s'", this.url, DOMAIN));
            }
            return this.url.substring(DOMAIN.length()).split(Coordinates.SEPARATOR, 2);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Https)) {
                return false;
            }
            Https other = (Https)o;
            String this$url = this.url;
            String other$url = other.url;
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.url;
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }

    @Immutable
    public static final class Simple
    implements Coordinates {
        private final transient String usr;
        private final transient String rpo;

        public Simple(String user, String repo) {
            this.usr = user;
            this.rpo = repo;
        }

        public Simple(String mnemo) {
            String[] parts = mnemo.split(Coordinates.SEPARATOR, 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException(String.format("invalid coordinates '%s'", mnemo));
            }
            this.usr = parts[0];
            this.rpo = parts[1];
        }

        public String toString() {
            return String.format("%s/%s", this.usr, this.rpo);
        }

        @Override
        public String user() {
            return this.usr;
        }

        @Override
        public String repo() {
            return this.rpo;
        }

        @Override
        public int compareTo(Coordinates other) {
            return new CompareToBuilder().append(this.usr, other.user()).append(this.rpo, other.repo()).build();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Simple)) {
                return false;
            }
            Simple other = (Simple)o;
            String this$usr = this.usr;
            String other$usr = other.usr;
            if (this$usr == null ? other$usr != null : !this$usr.equals(other$usr)) {
                return false;
            }
            String this$rpo = this.rpo;
            String other$rpo = other.rpo;
            return !(this$rpo == null ? other$rpo != null : !this$rpo.equals(other$rpo));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $usr = this.usr;
            result = result * 59 + ($usr == null ? 43 : $usr.hashCode());
            String $rpo = this.rpo;
            result = result * 59 + ($rpo == null ? 43 : $rpo.hashCode());
            return result;
        }
    }
}

