/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.google.common.base.Optional;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.SmartJson;
import com.jcabi.github.StringEnum;
import java.io.IOException;
import java.util.Locale;
import javax.json.JsonObject;

@Immutable
public interface FileChange
extends JsonReadable {

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements FileChange {
        private final transient FileChange change;
        private final transient SmartJson jsn;

        public Smart(FileChange chng) {
            this.change = chng;
            this.jsn = new SmartJson(chng);
        }

        public String sha() throws IOException {
            return this.jsn.text("sha");
        }

        public String filename() throws IOException {
            return this.jsn.text("filename");
        }

        public Status status() throws IOException {
            return Status.forValue(this.jsn.text("status"));
        }

        public int additions() throws IOException {
            return this.jsn.number("additions");
        }

        public int deletions() throws IOException {
            return this.jsn.number("deletions");
        }

        public int changes() throws IOException {
            return this.jsn.number("changes");
        }

        public Optional<String> patch() throws IOException {
            return Optional.fromNullable(this.json().getString("patch", null));
        }

        public String rawUrl() throws IOException {
            return this.jsn.text("raw_url");
        }

        public String blobUrl() throws IOException {
            return this.jsn.text("blob_url");
        }

        public String contentsUrl() throws IOException {
            return this.jsn.text("contents_url");
        }

        @Override
        public JsonObject json() throws IOException {
            return this.change.json();
        }

        public String toString() {
            return "FileChange.Smart(change=" + this.change + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            FileChange this$change = this.change;
            FileChange other$change = other.change;
            if (this$change == null ? other$change != null : !this$change.equals(other$change)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FileChange $change = this.change;
            result = result * 59 + ($change == null ? 43 : $change.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }

    public static enum Status implements StringEnum
    {
        ADDED("added"),
        MODIFIED("modified"),
        REMOVED("removed"),
        RENAMED("renamed");

        private final transient String status;

        private Status(String stat) {
            this.status = stat;
        }

        @Override
        public String identifier() {
            return this.status;
        }

        public static Status forValue(String name) {
            return Status.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
    }
}

