/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Repo;
import com.jcabi.github.SmartJson;
import java.io.IOException;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.commons.lang3.builder.CompareToBuilder;

@Immutable
public interface Label
extends Comparable<Label>,
JsonReadable,
JsonPatchable {
    public Repo repo();

    public String name();

    @Immutable
    @Loggable(value=1)
    public static final class Unmodified
    implements Label {
        private final transient Repo repo;
        private final transient String obj;

        public Unmodified(Repo rep, String object) {
            this.repo = rep;
            this.obj = object;
        }

        @Override
        public Repo repo() {
            return this.repo;
        }

        @Override
        public String name() {
            return this.json().getString("name");
        }

        @Override
        public int compareTo(Label label) {
            return new CompareToBuilder().append(this.repo().coordinates(), label.repo().coordinates()).append(this.obj, label.name()).build();
        }

        @Override
        public void patch(JsonObject json) {
            throw new UnsupportedOperationException("#patch()");
        }

        @Override
        public JsonObject json() {
            return Json.createReader(new StringReader(this.obj)).readObject();
        }

        public String toString() {
            return "Label.Unmodified(repo=" + this.repo + ", obj=" + this.obj + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unmodified)) {
                return false;
            }
            Unmodified other = (Unmodified)o;
            Repo this$repo = this.repo;
            Repo other$repo = other.repo;
            if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
                return false;
            }
            String this$obj = this.obj;
            String other$obj = other.obj;
            return !(this$obj == null ? other$obj != null : !this$obj.equals(other$obj));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Repo $repo = this.repo;
            result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
            String $obj = this.obj;
            result = result * 59 + ($obj == null ? 43 : $obj.hashCode());
            return result;
        }
    }

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Label {
        private final transient Label label;
        private final transient SmartJson jsn;

        public Smart(Label lbl) {
            this.label = lbl;
            this.jsn = new SmartJson(lbl);
        }

        public String color() throws IOException {
            return this.jsn.text("color");
        }

        public void color(String color) throws IOException {
            this.label.patch(Json.createObjectBuilder().add("color", color).build());
        }

        @Override
        public Repo repo() {
            return this.label.repo();
        }

        @Override
        public String name() {
            return this.label.name();
        }

        @Override
        public int compareTo(Label lbl) {
            return this.label.compareTo(lbl);
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.label.patch(json);
        }

        @Override
        public JsonObject json() throws IOException {
            return this.label.json();
        }

        public String toString() {
            return "Label.Smart(label=" + this.label + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Label this$label = this.label;
            Label other$label = other.label;
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Label $label = this.label;
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

