/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comment;
import com.jcabi.github.Comments;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.Issue;
import com.jcabi.github.RtComment;
import com.jcabi.github.RtPagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtComments
implements Comments {
    private final transient Request entry;
    private final transient Request request;
    private final transient Issue owner;

    RtComments(Request req, Issue issue) {
        this.entry = req;
        Coordinates coords = issue.repo().coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/issues").path(Integer.toString(issue.number())).path("/comments").back();
        this.owner = issue;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Issue issue() {
        return this.owner;
    }

    @Override
    public Comment get(int number) {
        return new RtComment(this.entry, this.owner, number);
    }

    @Override
    public Comment post(String text) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("body", text).build();
        return this.get(this.request.method("POST").body().set(json).back().fetch().as(RestResponse.class).assertStatus(201).as(JsonResponse.class).json().readObject().getInt("id"));
    }

    @Override
    public Iterable<Comment> iterate(Date since) {
        return new RtPagination<Comment>(this.request.uri().queryParam("since", new Github.Time(since)).back(), object -> this.get(object.getInt("id")));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtComments)) {
            return false;
        }
        RtComments other = (RtComments)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Issue this$owner = this.owner;
        Issue other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Issue $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

