/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Commit;
import com.jcabi.github.Commits;
import com.jcabi.github.Repo;
import com.jcabi.github.RtCommit;
import com.jcabi.github.RtStatuses;
import com.jcabi.github.Statuses;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
public final class RtCommits
implements Commits {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    RtCommits(Request req, Repo repo) {
        this.entry = req;
        this.owner = repo;
        this.request = req.uri().path("/repos").path(repo.coordinates().user()).path(repo.coordinates().repo()).path("/git").path("/commits").back();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Commit create(JsonObject params) throws IOException {
        return this.get(this.request.method("POST").body().set(params).back().fetch().as(RestResponse.class).assertStatus(201).as(JsonResponse.class).json().readObject().getString("sha"));
    }

    @Override
    public Commit get(String sha) {
        return new RtCommit(this.entry, this.owner, sha);
    }

    @Override
    public Statuses statuses(String ref) {
        return new RtStatuses(this.entry, this.get(ref));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtCommits)) {
            return false;
        }
        RtCommits other = (RtCommits)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

