/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Content;
import com.jcabi.github.Contents;
import com.jcabi.github.Repo;
import com.jcabi.github.RepoCommit;
import com.jcabi.github.RtContent;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtRepoCommit;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;

@Immutable
@Loggable(value=1)
final class RtContents
implements Contents {
    private final transient Request entry;
    private final transient Repo owner;
    private final transient Request request;

    public RtContents(Request req, Repo repo) {
        this.entry = req;
        this.owner = repo;
        this.request = req.uri().path("/repos").path(repo.coordinates().user()).path(repo.coordinates().repo()).path("/contents").back();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Content readme() throws IOException {
        return new RtContent(this.entry, this.owner, this.entry.uri().path("/repos").path(this.owner.coordinates().user()).path(this.owner.coordinates().repo()).path("/readme").back().method("GET").fetch().as(RestResponse.class).assertStatus(200).as(JsonResponse.class).json().readObject().getString("path"));
    }

    @Override
    public Content readme(String branch) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("ref", branch).build();
        return new RtContent(this.entry, this.owner, this.entry.uri().path("/repos").path(this.owner.coordinates().user()).path(this.owner.coordinates().repo()).path("/readme").back().method("GET").body().set(json).back().fetch().as(RestResponse.class).assertStatus(200).as(JsonResponse.class).json().readObject().getString("path"));
    }

    @Override
    public Content create(JsonObject content) throws IOException {
        if (!content.containsKey("path")) {
            throw new IllegalStateException("Content should have path parameter");
        }
        String path = content.getString("path");
        return new RtContent(this.entry, this.owner, this.request.method("PUT").uri().path(path).back().body().set(content).back().fetch().as(RestResponse.class).assertStatus(201).as(JsonResponse.class).json().readObject().getJsonObject("content").getString("path"));
    }

    @Override
    public Content get(String path, String ref) throws IOException {
        return this.content(path, ref);
    }

    @Override
    public Content get(String path) throws IOException {
        return this.content(path, this.repo().defaultBranch().name());
    }

    @Override
    public Iterable<Content> iterate(String path, String ref) {
        return new RtPagination<Content>(this.request.method("GET").uri().path(path).queryParam("ref", ref).back(), object -> new RtContent(this.entry, this.owner, object.getString("path")));
    }

    @Override
    public RepoCommit remove(JsonObject content) throws IOException {
        if (!content.containsKey("path")) {
            throw new IllegalStateException("Content should have path parameter");
        }
        String path = content.getString("path");
        return new RtRepoCommit(this.entry, this.owner, this.request.method("DELETE").uri().path(path).back().body().set(content).back().fetch().as(RestResponse.class).assertStatus(200).as(JsonResponse.class).json().readObject().getJsonObject("commit").getString("sha"));
    }

    @Override
    public RepoCommit update(String path, JsonObject json) throws IOException {
        return new RtRepoCommit(this.entry, this.owner, this.request.uri().path(path).back().method("PUT").body().set(json).back().fetch().as(RestResponse.class).assertStatus(200).as(JsonResponse.class).json().readObject().getJsonObject("commit").getString("sha"));
    }

    @Override
    public boolean exists(String path, String ref) throws IOException {
        RestResponse response = this.request.method("GET").uri().path(path).queryParam("ref", ref).back().fetch().as(RestResponse.class);
        return response.status() == 200;
    }

    private Content content(String path, String ref) throws IOException {
        String name = "ref";
        RtContent content = null;
        JsonStructure structure = this.request.method("GET").uri().path(path).queryParam("ref", ref).back().fetch().as(RestResponse.class).assertStatus(200).as(JsonResponse.class).json().read();
        if (JsonValue.ValueType.OBJECT.equals((Object)structure.getValueType())) {
            content = new RtContent(this.entry.uri().queryParam("ref", ref).back(), this.owner, ((JsonObject)structure).getString("path"));
        }
        return content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtContents)) {
            return false;
        }
        RtContents other = (RtContents)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

