/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comments;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Event;
import com.jcabi.github.Existence;
import com.jcabi.github.Issue;
import com.jcabi.github.IssueLabels;
import com.jcabi.github.Reaction;
import com.jcabi.github.Repo;
import com.jcabi.github.RtComments;
import com.jcabi.github.RtEvent;
import com.jcabi.github.RtIssueLabels;
import com.jcabi.github.RtJson;
import com.jcabi.github.RtPagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtIssue
implements Issue {
    private static final String CONTENT = "content";
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;
    private final transient int num;

    RtIssue(Request req, Repo repo, int number) {
        this.entry = req;
        Coordinates coords = repo.coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/issues").path(Integer.toString(number)).back();
        this.owner = repo;
        this.num = number;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public Comments comments() {
        return new RtComments(this.entry, this);
    }

    @Override
    public IssueLabels labels() {
        return new RtIssueLabels(this.entry, this);
    }

    @Override
    public Iterable<Event> events() {
        return new RtPagination<Event>(this.request.uri().path("/events").back(), object -> new RtEvent(this.entry, this.owner, object.getInt("id")));
    }

    @Override
    public boolean exists() throws IOException {
        return new Existence(this).check();
    }

    @Override
    public void react(Reaction reaction) throws IOException {
        JsonObject json = Json.createObjectBuilder().add(CONTENT, reaction.type()).build();
        this.request.method("POST").body().set(json).back().fetch().as(RestResponse.class).assertStatus(200);
    }

    @Override
    public Iterable<Reaction> reactions() {
        return new RtPagination<Reaction>(this.request.uri().path("/reactions").back(), object -> new Reaction.Simple(object.getString(CONTENT)));
    }

    @Override
    public void lock(String reason) {
        JsonObject json = Json.createObjectBuilder().add("lock_reason", reason).build();
        try {
            this.request.method("PUT").uri().path("/lock").back().body().set(json).back().fetch().as(RestResponse.class).assertStatus(204);
        }
        catch (IOException error) {
            throw new IllegalStateException(error);
        }
    }

    @Override
    public void unlock() {
        try {
            this.request.method("DELETE").uri().path("/lock").back().fetch().as(RestResponse.class).assertStatus(204);
        }
        catch (IOException error) {
            throw new IllegalStateException(error);
        }
    }

    @Override
    public boolean isLocked() {
        boolean locked = false;
        try {
            locked ^= this.request.method("PUT").uri().path("/lock").back().fetch().as(RestResponse.class).assertStatus(204).back().body().get().isEmpty();
        }
        catch (IOException error) {
            locked = false;
        }
        return locked;
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public int compareTo(Issue issue) {
        return this.number() - issue.number();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtIssue)) {
            return false;
        }
        RtIssue other = (RtIssue)o;
        if (this.num != other.num) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.num;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

