/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Github;
import com.jcabi.github.Limit;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtLimit
implements Limit {
    private final transient Request entry;
    private final transient Github ghub;
    private final transient String res;

    RtLimit(Github github, Request req, String name) {
        this.entry = req;
        this.ghub = github;
        this.res = name;
    }

    @Override
    public Github github() {
        return this.ghub;
    }

    @Override
    public JsonObject json() throws IOException {
        JsonObject json = new RtJson(this.entry).fetch().getJsonObject("resources");
        if (!json.containsKey(this.res)) {
            throw new IllegalStateException(String.format("'%s' is absent in JSON: %s", this.res, json));
        }
        return json.getJsonObject(this.res);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtLimit)) {
            return false;
        }
        RtLimit other = (RtLimit)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Github this$ghub = this.ghub;
        Github other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        String this$res = this.res;
        String other$res = other.res;
        return !(this$res == null ? other$res != null : !this$res.equals(other$res));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Github $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        String $res = this.res;
        result = result * 59 + ($res == null ? 43 : $res.hashCode());
        return result;
    }
}

