/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Milestone;
import com.jcabi.github.Milestones;
import com.jcabi.github.Repo;
import com.jcabi.github.RtMilestone;
import com.jcabi.github.RtPagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtMilestones
implements Milestones {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    RtMilestones(Request req, Repo repo) {
        this.entry = req;
        Coordinates coords = repo.coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/milestones").back();
        this.owner = repo;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Milestone create(String title) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("title", title).build();
        return this.get(this.request.method("POST").body().set(json).back().fetch().as(RestResponse.class).assertStatus(201).as(JsonResponse.class).json().readObject().getInt("number"));
    }

    @Override
    public Milestone get(int number) {
        return new RtMilestone(this.entry, this.owner, number);
    }

    @Override
    public void remove(int number) throws IOException {
        this.request.method("DELETE").uri().path(Integer.toString(number)).back().fetch().as(RestResponse.class).assertStatus(204);
    }

    @Override
    public Iterable<Milestone> iterate(Map<String, String> params) {
        return new RtPagination<Milestone>(this.request.uri().queryParams(params).back(), object -> this.get(object.getInt("number")));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtMilestones)) {
            return false;
        }
        RtMilestones other = (RtMilestones)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

