/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Reference;
import com.jcabi.github.References;
import com.jcabi.github.Repo;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtReference;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtReferences
implements References {
    private static final String REF = "ref";
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    RtReferences(Request req, Repo repo) {
        this.entry = req;
        this.owner = repo;
        this.request = req.uri().path("/repos").path(repo.coordinates().user()).path(repo.coordinates().repo()).path("/git").path("/refs").back();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Reference create(String ref, String sha) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("sha", sha).add(REF, ref).build();
        return this.get(this.request.method("POST").body().set(json).back().fetch().as(RestResponse.class).assertStatus(201).as(JsonResponse.class).json().readObject().getString(REF));
    }

    @Override
    public Reference get(String identifier) {
        return new RtReference(this.entry, this.owner, identifier);
    }

    @Override
    public Iterable<Reference> iterate() {
        return new RtPagination<Reference>(this.request, object -> this.get(object.getString(REF)));
    }

    @Override
    public Iterable<Reference> iterate(String subnamespace) {
        return new RtPagination<Reference>(this.request.uri().path(subnamespace).back(), object -> this.get(object.getString(REF)));
    }

    @Override
    public Iterable<Reference> tags() {
        return this.iterate("tags");
    }

    @Override
    public Iterable<Reference> heads() {
        return this.iterate("heads");
    }

    @Override
    public void remove(String identifier) throws IOException {
        this.request.method("DELETE").uri().path(identifier).back().fetch().as(RestResponse.class).assertStatus(204);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtReferences)) {
            return false;
        }
        RtReferences other = (RtReferences)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

