/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Repo;
import com.jcabi.github.RtTree;
import com.jcabi.github.Tree;
import com.jcabi.github.Trees;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtTrees
implements Trees {
    private final transient Request entry;
    private final transient Repo owner;
    private final transient Request request;

    RtTrees(Request req, Repo repo) {
        this.entry = req;
        this.owner = repo;
        this.request = req.uri().path("/repos").path(repo.coordinates().user()).path(repo.coordinates().repo()).path("/git").path("/trees").back();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Tree get(String sha) {
        return new RtTree(this.entry, this.owner, sha);
    }

    @Override
    public Tree getRec(String sha) {
        return new RtTree(this.entry.uri().queryParam("recursive", "1").back(), this.owner, sha);
    }

    @Override
    public Tree create(JsonObject params) throws IOException {
        return this.get(this.request.method("POST").body().set(params).back().fetch().as(RestResponse.class).assertStatus(201).as(JsonResponse.class).json().readObject().getString("sha"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtTrees)) {
            return false;
        }
        RtTrees other = (RtTrees)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

