/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Github;
import com.jcabi.github.Notifications;
import com.jcabi.github.PublicKeys;
import com.jcabi.github.RtJson;
import com.jcabi.github.RtNotifications;
import com.jcabi.github.RtPublicKeys;
import com.jcabi.github.RtUserEmails;
import com.jcabi.github.RtUserOrganizations;
import com.jcabi.github.User;
import com.jcabi.github.UserEmails;
import com.jcabi.github.UserOrganizations;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtUser
implements User {
    private static final String NOTIF_PATH = "notifications";
    private final transient Github ghub;
    private final transient Request request;
    private final transient String self;

    RtUser(Github github, Request req) {
        this(github, req, "");
    }

    RtUser(Github github, Request req, String login) {
        this.ghub = github;
        this.request = login.isEmpty() ? req.uri().path("/user").back() : req.uri().path("/users").path(login).back();
        this.self = login;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Github github() {
        return this.ghub;
    }

    @Override
    public String login() throws IOException {
        String login = this.self.isEmpty() ? this.json().getString("login") : this.self;
        return login;
    }

    @Override
    public UserOrganizations organizations() {
        return new RtUserOrganizations(this.ghub, this.ghub.entry(), this);
    }

    @Override
    public PublicKeys keys() {
        return new RtPublicKeys(this.ghub.entry(), this);
    }

    @Override
    public UserEmails emails() {
        return new RtUserEmails(this.ghub.entry());
    }

    @Override
    public Notifications notifications() {
        return new RtNotifications(this.github().entry().uri().path(NOTIF_PATH).back());
    }

    @Override
    public void markAsRead(Date lastread) throws IOException {
        this.github().entry().uri().path(NOTIF_PATH).queryParam("last_read_at", DateTimeFormatter.ISO_INSTANT.format(lastread.toInstant())).back().method("PUT").fetch().as(RestResponse.class).assertStatus(205);
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtUser)) {
            return false;
        }
        RtUser other = (RtUser)o;
        Github this$ghub = this.ghub;
        Github other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Github $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

