/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.google.common.base.Optional;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Commit;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Status;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

@Immutable
public interface Statuses
extends JsonReadable {
    public Commit commit();

    public Status create(StatusCreate var1) throws IOException;

    public Iterable<Status> list(String var1);

    @Loggable(value=1)
    public static final class StatusCreate
    implements JsonReadable {
        private final transient Status.State state;
        private final transient String description;
        private final transient Optional<String> context;
        private final transient Optional<String> targeturl;

        public StatusCreate(Status.State stat) {
            this(stat, "", Optional.absent(), Optional.absent());
        }

        private StatusCreate(Status.State stat, String desc, Optional<String> cntxt, Optional<String> target) {
            this.state = stat;
            this.description = desc;
            this.context = cntxt;
            this.targeturl = target;
        }

        public StatusCreate withState(Status.State stat) {
            return new StatusCreate(stat, this.description, this.context, this.targeturl);
        }

        public StatusCreate withDescription(String desc) {
            return new StatusCreate(this.state, desc, this.context, this.targeturl);
        }

        public StatusCreate withContext(Optional<String> cntxt) {
            return new StatusCreate(this.state, this.description, cntxt, this.targeturl);
        }

        public StatusCreate withTargetUrl(Optional<String> target) {
            return new StatusCreate(this.state, this.description, this.context, target);
        }

        @Override
        public JsonObject json() {
            JsonObjectBuilder builder = Json.createObjectBuilder().add("state", this.state.identifier()).add("description", this.description);
            if (this.context.isPresent()) {
                builder.add("context", this.context.get());
            }
            if (this.targeturl.isPresent()) {
                builder.add("target_url", this.targeturl.get());
            }
            return builder.build();
        }

        public String toString() {
            return "Statuses.StatusCreate(state=" + this.state + ", description=" + this.description + ", context=" + this.context + ", targeturl=" + this.targeturl + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusCreate)) {
                return false;
            }
            StatusCreate other = (StatusCreate)o;
            Status.State this$state = this.state;
            Status.State other$state = other.state;
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$description = this.description;
            String other$description = other.description;
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Optional<String> this$context = this.context;
            Optional<String> other$context = other.context;
            if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
                return false;
            }
            Optional<String> this$targeturl = this.targeturl;
            Optional<String> other$targeturl = other.targeturl;
            return !(this$targeturl == null ? other$targeturl != null : !((Object)this$targeturl).equals(other$targeturl));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Status.State $state = this.state;
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $description = this.description;
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Optional<String> $context = this.context;
            result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
            Optional<String> $targeturl = this.targeturl;
            result = result * 59 + ($targeturl == null ? 43 : ((Object)$targeturl).hashCode());
            return result;
        }
    }
}

